/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.utils;

public final class IllegalStateAssertion {
    private IllegalStateAssertion() {
    }

    public static <T> T assertNull(T value, String message) {
        if (value != null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T assertNotNull(T value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean assertTrue(Boolean value, String message) {
        if (!Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean assertFalse(Boolean value, String message) {
        if (Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T assertEquals(T exp, T was, String message) {
        IllegalStateAssertion.assertNotNull(exp, message);
        IllegalStateAssertion.assertNotNull(was, message);
        IllegalStateAssertion.assertTrue(exp.equals(was), message);
        return was;
    }

    public static <T> T assertSame(T exp, T was, String message) {
        IllegalStateAssertion.assertNotNull(exp, message);
        IllegalStateAssertion.assertNotNull(was, message);
        IllegalStateAssertion.assertTrue(exp == was, message);
        return was;
    }
}

