/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.aether;

import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferListener;
import org.wildfly.extras.patch.aether.AetherFactory;
import org.wildfly.extras.patch.aether.ConsoleRepositoryListener;
import org.wildfly.extras.patch.aether.ConsoleTransferListener;
import org.wildfly.extras.patch.aether.ManualRepositorySystemFactory;

public abstract class DefaultAetherFactory
implements AetherFactory {
    private RepositorySystem system;
    private RemoteRepository repository;
    private LocalRepository localRepo;

    @Override
    public RepositorySystem getRepositorySystem() {
        if (this.system == null) {
            this.system = ManualRepositorySystemFactory.newRepositorySystem();
            this.repository = new RemoteRepository.Builder("fusepatch.repository", "default", this.getRepositoryURL().toString()).build();
            this.localRepo = new LocalRepository(this.getLocalRepositoryPath().toFile());
        }
        return this.system;
    }

    @Override
    public RepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)session, this.localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener(System.out));
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener(System.out));
        return session;
    }

    @Override
    public RemoteRepository getRemoteRepository() {
        return this.repository;
    }
}

