/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.server.WildFlyServer;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public final class DefaultPatchTool
extends PatchTool {
    private final ReentrantLock lock;
    private final Repository repository;
    private Server server;

    public DefaultPatchTool(ReentrantLock lock, Server server, Repository repository) {
        IllegalArgumentAssertion.assertNotNull(lock, "lock");
        IllegalArgumentAssertion.assertNotNull(repository, "repository");
        this.lock = lock;
        this.server = server;
        this.repository = repository;
    }

    @Override
    public Server getServer() {
        this.lock.tryLock();
        try {
            if (this.server == null) {
                this.server = new WildFlyServer(this.lock, null);
            }
            Server server = this.server;
            return server;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Patch install(PatchId patchId, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            Patch patch = this.installInternal(patchId, force);
            return patch;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Patch update(String prefix, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        this.lock.tryLock();
        try {
            PatchId latestId = this.getRepository().getLatestAvailable(prefix);
            PatchAssertion.assertNotNull(latestId, "Cannot obtain patch id for prefix: " + prefix);
            Patch patch = this.installInternal(latestId, force);
            return patch;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Patch uninstall(PatchId patchId) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            Patch installed = this.getServer().getPatch(patchId);
            PatchAssertion.assertNotNull(installed, "Patch not installed: " + patchId);
            PatchId latestId = this.getServer().getPatch(patchId.getName()).getPatchId();
            PatchAssertion.assertEquals(patchId, latestId, "Active package is " + latestId + ", cannot uninstall: " + patchId);
            try (SmartPatch smartPatch = SmartPatch.forUninstall(installed);){
                Patch patch = this.getServer().applySmartPatch(smartPatch, false);
                return patch;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Patch installInternal(PatchId patchId, boolean force) throws IOException {
        PatchId serverId = null;
        String prefix = patchId.getName();
        for (PatchId pid : this.getServer().queryAppliedPatches()) {
            if (!pid.getName().equals(prefix)) continue;
            serverId = pid;
            break;
        }
        Patch seedPatch = serverId != null ? this.getServer().getPatch(serverId) : null;
        try (SmartPatch smartPatch = this.getRepository().getSmartPatch(seedPatch, patchId);){
            Patch patch = this.getServer().applySmartPatch(smartPatch, force);
            return patch;
        }
    }

    public String toString() {
        return "DefaultPatchTool[server=" + this.server + ",repo=" + this.repository + "]";
    }
}

