/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.util.NoSuchElementException;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    private transient String versionString;
    private transient int hash;
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    public Version(String version) {
        int[] arr = new int[3];
        String qual = "";
        try {
            String part = version;
            for (int i = 0; i < 3; ++i) {
                PRes res = this.parse(part, version);
                arr[i] = res.val;
                if (res.rest == null) break;
                if (i == 2 || res.rest.startsWith("-")) {
                    qual = res.rest;
                    break;
                }
                part = res.rest.substring(1);
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
            iae.initCause(e);
            throw iae;
        }
        this.major = arr[0];
        this.minor = arr[1];
        this.micro = arr[2];
        this.qualifier = qual;
        this.validate();
    }

    private PRes parse(String part, String version) {
        PRes result = new PRes();
        int idx = this.nextdelim(part);
        if (idx < 0) {
            result.val = Version.parseInt(part, version);
        } else if (idx > 0) {
            result.val = Version.parseInt(part.substring(0, idx), version);
            result.rest = part.substring(idx);
        } else {
            throw new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
        }
        return result;
    }

    private int nextdelim(String part) {
        int result = part.indexOf(SEPARATOR);
        return result >= 0 ? result : part.indexOf(45);
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": non-numeric \"" + value + "\"");
            iae.initCause(e);
            throw iae;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.minor + "\"");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.micro + "\"");
        }
        String qual = this.qualifier.length() > 1 ? this.qualifier.substring(1) : "";
        for (char ch : qual.toCharArray()) {
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '-') continue;
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": invalid qualifier \"" + this.qualifier + "\"");
        }
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier != null ? this.qualifier.substring(1) : null;
    }

    public String toString() {
        return this.toString0();
    }

    String toString0() {
        if (this.versionString != null) {
            return this.versionString;
        }
        int q = this.qualifier.length();
        StringBuffer result = new StringBuffer(20 + q);
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.micro);
        if (q > 0) {
            result.append(this.qualifier);
        }
        this.versionString = result.toString();
        return this.versionString;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.micro;
        this.hash = h = 31 * h + this.qualifier.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    class PRes {
        int val;
        String rest;

        PRes() {
        }
    }
}

