/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.jaxws;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.activation.DataHandler;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.repository.LocalFileRepository;
import org.wildfly.extras.patch.repository.PatchAdapter;
import org.wildfly.extras.patch.repository.PatchMetadataAdapter;
import org.wildfly.extras.patch.repository.RepositoryService;
import org.wildfly.extras.patch.repository.SmartPatchAdapter;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

@WebService(targetNamespace="http://jaxws.patch.extras.wildfly.org/", endpointInterface="org.wildfly.extras.patch.repository.RepositoryService")
public class RepositoryEndpoint
implements RepositoryService {
    @Resource
    private WebServiceContext context;
    private final ReentrantLock lock = new ReentrantLock();
    private Repository delegate;

    @PostConstruct
    public void postConstruct() {
        URL repoURL = this.getRepositoryURL();
        PatchToolBuilder builder = new PatchToolBuilder().customLock(this.lock).repositoryURL(repoURL);
        this.delegate = builder.build().getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] queryAvailable(String prefix) {
        this.lock.tryLock();
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (PatchId pid : this.delegate.queryAvailable(prefix)) {
                result.add(pid.toString());
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull((Object)prefix, (String)"prefix");
        this.lock.tryLock();
        try {
            PatchId patchId = this.delegate.getLatestAvailable(prefix);
            String string = patchId != null ? patchId.toString() : null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PatchAdapter getPatch(String patchId) {
        IllegalArgumentAssertion.assertNotNull((Object)patchId, (String)"patchId");
        this.lock.tryLock();
        try {
            PatchAdapter patchAdapter = PatchAdapter.fromPatch((Patch)this.delegate.getPatch(PatchId.fromString((String)patchId)));
            return patchAdapter;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addArchive(PatchMetadataAdapter metadata, DataHandler dataHandler, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull((Object)metadata, (String)"metadata");
        IllegalArgumentAssertion.assertNotNull((Object)dataHandler, (String)"dataHandler");
        this.lock.tryLock();
        try {
            String string = this.delegate.addArchive(metadata.toPatchMetadata(), dataHandler, force).toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean removeArchive(String patchId) {
        IllegalArgumentAssertion.assertNotNull((Object)patchId, (String)"patchId");
        this.lock.tryLock();
        try {
            boolean bl = this.delegate.removeArchive(PatchId.fromString((String)patchId));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmartPatchAdapter getSmartPatch(PatchAdapter seedPatch, String patchId) {
        this.lock.tryLock();
        try {
            PatchMetadata metadata;
            PatchId pid;
            Patch seed = seedPatch != null ? seedPatch.toPatch() : null;
            PatchId patchId2 = pid = patchId != null ? PatchId.fromString((String)patchId) : null;
            if (pid == null) {
                IllegalArgumentAssertion.assertNotNull((Object)seedPatch, (String)"seedPatch");
                metadata = seedPatch.getMetadata().toPatchMetadata();
                pid = this.delegate.getLatestAvailable(metadata.getPatchId().getName());
            }
            metadata = this.delegate.getPatch(pid).getMetadata();
            HttpServletRequest servletRequest = (HttpServletRequest)this.context.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
            for (String role : metadata.getRoles()) {
                if (servletRequest.isUserInRole(role)) continue;
                throw new WebServiceException((Throwable)new SecurityException("User does not have required role: " + role));
            }
            SmartPatch smartPatch = this.delegate.getSmartPatch(seed, pid);
            SmartPatchAdapter smartPatchAdapter = SmartPatchAdapter.fromSmartPatch((SmartPatch)smartPatch);
            return smartPatchAdapter;
        }
        finally {
            this.lock.unlock();
        }
    }

    private URL getRepositoryURL() {
        URL repoUrl = LocalFileRepository.getDefaultRepositoryURL();
        ServletContext servletContext = (ServletContext)this.context.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
        String repoSpec = servletContext.getInitParameter("fusepatch.repository");
        if (repoSpec != null) {
            try {
                repoUrl = new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return repoUrl;
    }
}

