/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.context.propagation.deployment;

import io.smallrye.context.SmallRyeContextManagerProvider;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.microprofile.context.propagation.mutiny.ThreadContextRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ContextPropagationDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String weldCapabilityName;

    public ContextPropagationDeploymentProcessor(String weldCapabilityName) {
        this.weldCapabilityName = weldCapabilityName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit context) {
        Module module = (Module)context.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
            SmallRyeContextManagerProvider contextManagerProvider = SmallRyeContextManagerProvider.instance();
            ContextManager mgr = contextManagerProvider.findContextManager((ClassLoader)classLoader);
            if (mgr != null) {
                contextManagerProvider.releaseContextManager(mgr);
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
        ThreadContextRegistry tcr = ThreadContextRegistry.INSTANCE;
        tcr.cleanup((ClassLoader)classLoader);
    }
}

