/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.context.propagation.providers;

import java.security.PrivilegedAction;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        return ApplicationThreadContextSnapshot.create(true);
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return ApplicationThreadContextSnapshot.create(false);
    }

    public String getThreadContextType() {
        return "Application";
    }

    private static class GetSystemClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        static final GetSystemClassLoaderAction INSTANCE = new GetSystemClassLoaderAction();

        private GetSystemClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private static class ApplicationThreadContextSnapshot
    implements ThreadContextSnapshot {
        final ClassLoader tccl;
        final boolean propagate;

        private ApplicationThreadContextSnapshot(ClassLoader tccl, boolean propagate) {
            this.tccl = tccl;
            this.propagate = propagate;
        }

        static ApplicationThreadContextSnapshot create(boolean propagate) {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            return new ApplicationThreadContextSnapshot(tccl, propagate);
        }

        public ThreadContextController begin() {
            if (this.propagate) {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.tccl);
            } else {
                ClassLoader system = (ClassLoader)WildFlySecurityManager.doChecked((PrivilegedAction)GetSystemClassLoaderAction.INSTANCE);
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)system);
            }
            return new ThreadContextController(){

                public void endContext() throws IllegalStateException {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
                }
            };
        }
    }
}

