/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.integration.microprofile.shared;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class ModulesChecker {
    private List<String> expected = new ArrayList<String>();
    private List<String> notExpected = new ArrayList<String>();

    public ModulesChecker(Builder builder) {
        this.expected = new ArrayList<String>(builder.expected);
        this.notExpected = new ArrayList<String>(builder.notExpected);
    }

    public void checkModules() {
        Path path;
        Path modulesRoot = Paths.get(new File("target/wildfly/modules/system/layers/base").toURI());
        for (String s : this.expected) {
            path = modulesRoot.resolve(s);
            if (Files.exists(path, new LinkOption[0])) continue;
            throw new IllegalStateException("Expected module path " + path + " does not exist");
        }
        for (String s : this.notExpected) {
            path = modulesRoot.resolve(s);
            if (!Files.exists(path, new LinkOption[0])) continue;
            throw new IllegalStateException("Not expected module path " + path + " exists, but should not");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> expected = new ArrayList<String>();
        private List<String> notExpected = new ArrayList<String>();

        public Builder addExpected(String directory) {
            this.expected.add(directory);
            return this;
        }

        public Builder addNotExpected(String directory) {
            this.notExpected.add(directory);
            return this;
        }

        public ModulesChecker build() {
            return new ModulesChecker(this);
        }
    }
}

