/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.chat;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import java.time.Duration;
import java.util.List;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;

public class WildFlyMistralAiChatModelConfig
implements WildFlyChatModelConfig {
    private String key;
    private String baseUrl;
    private Boolean logRequests;
    private Boolean logResponses;
    private Integer maxTokens;
    private String modelName;
    private Integer randomSeed;
    private Boolean safePrompt;
    private Double temperature;
    private Duration connectTimeOut;
    private Double topP;
    private List<String> stopSequences;
    private Double presencePenalty;
    private Double frequencyPenalty;
    private Integer maxRetries;
    private boolean isJson;
    private boolean streaming;
    private boolean observable;
    private Object instance = null;

    @Override
    public ChatModel createLanguageModel(List<ChatModelListener> listeners) {
        if (this.instance == null) {
            MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).frequencyPenalty(this.frequencyPenalty).logRequests(this.logRequests).logResponses(this.logResponses).maxRetries(Integer.valueOf(this.maxRetries != null ? this.maxRetries : 5)).maxTokens(this.maxTokens).modelName(this.modelName).presencePenalty(this.presencePenalty).randomSeed(this.randomSeed).safePrompt(this.safePrompt).stopSequences(this.stopSequences).temperature(this.temperature).timeout(this.connectTimeOut).topP(this.topP);
            if (this.isJson) {
                builder.responseFormat(ResponseFormat.JSON);
            }
            if (this.observable && listeners != null && !listeners.isEmpty()) {
                builder.listeners(listeners);
            }
            this.instance = builder.build();
        }
        return (ChatModel)this.instance;
    }

    @Override
    public StreamingChatModel createStreamingLanguageModel(List<ChatModelListener> listeners) {
        if (this.instance == null) {
            MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).frequencyPenalty(this.frequencyPenalty).logRequests(this.logRequests).logResponses(this.logResponses).maxTokens(this.maxTokens).modelName(this.modelName).presencePenalty(this.presencePenalty).randomSeed(this.randomSeed).safePrompt(this.safePrompt).stopSequences(this.stopSequences).temperature(this.temperature).timeout(this.connectTimeOut).topP(this.topP);
            if (this.isJson) {
                builder.responseFormat(ResponseFormat.JSON);
            }
            this.instance = builder.build();
        }
        return (StreamingChatModel)this.instance;
    }

    public WildFlyMistralAiChatModelConfig apiKey(String key) {
        this.key = key;
        return this;
    }

    public WildFlyMistralAiChatModelConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WildFlyMistralAiChatModelConfig frequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public WildFlyMistralAiChatModelConfig logRequests(Boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public WildFlyMistralAiChatModelConfig logResponses(Boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public WildFlyMistralAiChatModelConfig maxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public WildFlyMistralAiChatModelConfig maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public WildFlyMistralAiChatModelConfig modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public WildFlyMistralAiChatModelConfig presencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public WildFlyMistralAiChatModelConfig randomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public WildFlyMistralAiChatModelConfig safePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
        return this;
    }

    public WildFlyMistralAiChatModelConfig setJson(boolean isJson) {
        this.isJson = isJson;
        return this;
    }

    public WildFlyMistralAiChatModelConfig setObservable(boolean observable) {
        this.observable = observable;
        return this;
    }

    public WildFlyMistralAiChatModelConfig stopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
        return this;
    }

    public WildFlyMistralAiChatModelConfig streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    public WildFlyMistralAiChatModelConfig temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public WildFlyMistralAiChatModelConfig timeout(long timeOut) {
        if (timeOut <= 0L) {
            this.connectTimeOut = null;
            return this;
        }
        this.connectTimeOut = Duration.ofMillis(timeOut);
        return this;
    }

    public WildFlyMistralAiChatModelConfig topP(Double topP) {
        this.topP = topP;
        return this;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    @Override
    public boolean isObservable() {
        return this.observable;
    }
}

