/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.retriever;

import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.store.embedding.EmbeddingStore;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;

public class EmbeddingStoreContentRetrieverConfig
implements WildFlyContentRetrieverConfig {
    private String embeddingStore;
    private String embeddingModel;
    private Integer maxResults;
    private Double minScore;

    @Override
    public ContentRetriever createContentRetriever(Instance<Object> lookup) {
        Instance embeddingStoreInstance = lookup.select(EmbeddingStore.class, new Annotation[]{NamedLiteral.of((String)this.embeddingStore)});
        Instance embeddingModelInstance = lookup.select(EmbeddingModel.class, new Annotation[]{NamedLiteral.of((String)this.embeddingModel)});
        return EmbeddingStoreContentRetriever.builder().embeddingStore((EmbeddingStore)embeddingStoreInstance.get()).embeddingModel((EmbeddingModel)embeddingModelInstance.get()).maxResults(this.maxResults).minScore(this.minScore).build();
    }

    public EmbeddingStoreContentRetrieverConfig embeddingStore(String embeddingStore) {
        this.embeddingStore = embeddingStore;
        return this;
    }

    public EmbeddingStoreContentRetrieverConfig embeddingModel(String embeddingModel) {
        this.embeddingModel = embeddingModel;
        return this;
    }

    public EmbeddingStoreContentRetrieverConfig maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public EmbeddingStoreContentRetrieverConfig minScore(Double minScore) {
        this.minScore = minScore;
        return this;
    }
}

