/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection;

import dev.langchain4j.cdi.core.config.spi.LLMConfig;
import dev.langchain4j.cdi.core.config.spi.ProducerFunction;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.extension.ai.injection.AILogger;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.memory.WildFlyChatMemoryProviderConfig;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;

public class WildFlyLLMConfig
extends LLMConfig {
    private static final Set<String> beanNames = new HashSet<String>();
    private static final Map<String, String> values = new HashMap<String, String>();

    public void registerBean(String name, Object value, Class<?> type) {
        beanNames.add(name);
        values.put(this.getBeanPropertyName(name, "class"), type.getName());
        values.put(this.getBeanPropertyName(name, "scope"), ApplicationScoped.class.getName());
        values.put(this.getBeanPropertyName(name, "defined_bean_producer"), this.getBeanPropertyName(name, "defined_bean_producer"));
        this.registerProducer(this.getBeanPropertyName(name, "defined_bean_producer"), this.createProducerFunction(value, type));
    }

    private ProducerFunction<Object> createProducerFunction(Object value, Class<?> expectedType) {
        if (ChatModel.class.isAssignableFrom(expectedType) || StreamingChatModel.class.isAssignableFrom(expectedType)) {
            return (lookup, beanName, llmConfig) -> {
                WildFlyChatModelConfig config = (WildFlyChatModelConfig)value;
                List<Object> listeners = config.isObservable() ? lookup.select(ChatModelListener.class, new Annotation[0]).handlesStream().map(Instance.Handle::get).collect(Collectors.toList()) : Collections.emptyList();
                AILogger.ROOT_LOGGER.info("Bean " + beanName + " of type " + String.valueOf(expectedType) + " has been produced");
                if (ChatModel.class.isAssignableFrom(expectedType) && !config.isStreaming()) {
                    return config.createLanguageModel(listeners);
                }
                if (StreamingChatModel.class.isAssignableFrom(expectedType) && config.isStreaming()) {
                    return config.createStreamingLanguageModel(listeners);
                }
                throw AILogger.ROOT_LOGGER.incorrectLLMConfiguration(beanName, expectedType.getName(), config.isStreaming());
            };
        }
        if (ContentRetriever.class.isAssignableFrom(expectedType)) {
            return (lookup, beanName, llmConfig) -> {
                AILogger.ROOT_LOGGER.info("Bean " + beanName + " of type " + String.valueOf(expectedType) + " has been produced");
                WildFlyContentRetrieverConfig config = (WildFlyContentRetrieverConfig)value;
                return config.createContentRetriever((Instance<Object>)lookup);
            };
        }
        if (ChatMemoryProvider.class.isAssignableFrom(expectedType)) {
            return (lookup, beanName, llmConfig) -> {
                AILogger.ROOT_LOGGER.info("Bean " + beanName + " of type " + String.valueOf(expectedType) + " has been produced");
                WildFlyChatMemoryProviderConfig config = (WildFlyChatMemoryProviderConfig)value;
                return config.createChatMemory((Instance<Object>)lookup);
            };
        }
        return (lookup, beanName, llmConfig) -> {
            AILogger.ROOT_LOGGER.info("Bean " + beanName + " of type " + String.valueOf(expectedType) + " has been produced");
            return value;
        };
    }

    public void init() {
    }

    public Set<String> getBeanNames() {
        return Collections.unmodifiableSet(beanNames);
    }

    public Set<String> getPropertyNamesForBean(String beanName) {
        return Collections.emptySet();
    }

    private String getBeanPropertyName(String beanName, String propertyName) {
        return "dev.langchain4j.plugin." + beanName + "." + propertyName;
    }

    public Set<String> getPropertyKeys() {
        return values.keySet();
    }

    public String getValue(String name) {
        return values.get(name);
    }
}

