/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.chat.GithubModelChatLanguageModelProviderRegistrar;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.chat.WildFlyGithubModelChatModelConfig;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class GithubModelChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    public GithubModelChatModelProviderServiceConfigurator(ValueRegistry<String, WildFlyChatModelConfig> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String endpoint = GithubModelChatLanguageModelProviderRegistrar.ENDPOINT.resolveModelAttribute(context, model).asString();
        final Map customHeaders = GithubModelChatLanguageModelProviderRegistrar.CUSTOM_HEADERS.unwrap((ExpressionResolver)context, model);
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Double frequencyPenalty = AIAttributeDefinitions.FREQUENCY_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final String key = AIAttributeDefinitions.API_KEY.resolveModelAttribute(context, model).asString();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final Integer maxRetries = AIAttributeDefinitions.MAX_RETRIES.resolveModelAttribute(context, model).asIntOrNull();
        final Integer maxToken = AIAttributeDefinitions.MAX_TOKEN.resolveModelAttribute(context, model).asIntOrNull();
        final Double presencePenalty = AIAttributeDefinitions.PRESENCE_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final Boolean logRequestsAndResponses = AIAttributeDefinitions.LOG_REQUESTS_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        final Long seed = GithubModelChatLanguageModelProviderRegistrar.SEED.resolveModelAttribute(context, model).asLongOrNull();
        final String serviceVersion = GithubModelChatLanguageModelProviderRegistrar.SERVICE_VERSION.resolveModelAttribute(context, model).asStringOrNull();
        final Boolean streaming = AIAttributeDefinitions.STREAMING.resolveModelAttribute(context, model).asBooleanOrNull();
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final Double topP = AIAttributeDefinitions.TOP_P.resolveModelAttribute(context, model).asDoubleOrNull();
        final String userAgentSuffix = GithubModelChatLanguageModelProviderRegistrar.USER_AGENT_SUFFIX.resolveModelAttribute(context, model).asStringOrNull();
        final boolean isObservable = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.opentelemetry");
        Supplier<WildFlyChatModelConfig> factory = new Supplier<WildFlyChatModelConfig>(){

            @Override
            public WildFlyChatModelConfig get() {
                return new WildFlyGithubModelChatModelConfig().customHeaders(customHeaders).endpoint(endpoint).frequencyPenalty(frequencyPenalty).gitHubToken(key).logRequestsAndResponses(logRequestsAndResponses).maxRetries(maxRetries).maxTokens(maxToken).modelName(modelName).presencePenalty(presencePenalty).seed(seed).serviceVersion(serviceVersion).setJson(isJson).setObservable(isObservable).setStreaming(streaming.booleanValue()).temperature(temperature).timeout(connectTimeOut.longValue()).topP(topP).userAgentSuffix(userAgentSuffix);
            }
        };
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

