/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.mcp.client;

import dev.langchain4j.mcp.McpToolProvider;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.service.tool.ToolProvider;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.mcp.client.McpToolProviderProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class McpToolProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final Boolean failIfOneServerFails = McpToolProviderProviderRegistrar.FAIL_IF_ONE_SERVER_FAILS.resolveModelAttribute(context, model).asBooleanOrNull();
        List clients = McpToolProviderProviderRegistrar.MCP_CLIENTS.unwrap((ExpressionResolver)context, model);
        final List mcpClientDeps = clients.stream().map(clientName -> ServiceDependency.on(Capabilities.MCP_CLIENT_DESCRIPTOR, (String)clientName)).collect(Collectors.toList());
        Supplier<ToolProvider> factory = new Supplier<ToolProvider>(){

            @Override
            public ToolProvider get() {
                List mcpClients = mcpClientDeps.stream().map(Supplier::get).map(client -> (McpClient)client.getMcpClient()).collect(Collectors.toList());
                return McpToolProvider.builder().failIfOneServerFails(failIfOneServerFails.booleanValue()).mcpClients(mcpClients).build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.TOOL_PROVIDER_CAPABILITY, (Supplier)factory).requires(mcpClientDeps)).blocking()).asActive()).build();
    }
}

