/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.rag.retriever;

import dev.langchain4j.model.input.PromptTemplate;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.injection.WildFlyBeanRegistry;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.retriever.Neo4JContentRetrieverConfig;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;
import org.wildfly.extension.ai.rag.retriever.Neo4JContentRetrieverProviderRegistrar;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class Neo4JContentRetrieverProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String boltUrl = AIAttributeDefinitions.BOLT_URL.resolveModelAttribute(context, model).asString();
        final String userName = AIAttributeDefinitions.USERNAME.resolveModelAttribute(context, model).asStringOrNull();
        String template = Neo4JContentRetrieverProviderRegistrar.PROMPT_TEMPLATE.resolveModelAttribute(context, model).asStringOrNull();
        final String chatLanguageModelName = Neo4JContentRetrieverProviderRegistrar.CHAT_LANGUAGE_MODEL.resolveModelAttribute(context, model).asString();
        final PromptTemplate promptTemplate = template == null ? null : PromptTemplate.from((String)template);
        final ServiceDependency credentialRef = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)AIAttributeDefinitions.CREDENTIAL_REFERENCE, (ModelNode)model));
        final ServiceDependency chatLanguageModel = ServiceDependency.on(Capabilities.CHAT_MODEL_PROVIDER_DESCRIPTOR, (String)chatLanguageModelName);
        Supplier<WildFlyContentRetrieverConfig> factory = new Supplier<WildFlyContentRetrieverConfig>(){

            @Override
            public WildFlyContentRetrieverConfig get() {
                String password;
                try {
                    password = String.valueOf(((ClearPassword)((PasswordCredential)((CredentialSource)credentialRef.get()).getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                WildFlyBeanRegistry.registerChatModel((String)chatLanguageModelName, (WildFlyChatModelConfig)((WildFlyChatModelConfig)chatLanguageModel.get()));
                return new Neo4JContentRetrieverConfig().boltUrl(boltUrl).chatLanguageModel(chatLanguageModelName).password(password).promptTemplate(promptTemplate).userName(userName);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CONTENT_RETRIEVER_PROVIDER_CAPABILITY, (Supplier)factory).requires((Consumer)credentialRef)).requires((Consumer)chatLanguageModel)).blocking()).asActive()).build();
    }
}

