/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.chat.ChatModelConnectionCheckerOperationHandler;
import org.wildfly.extension.ai.chat.MistralAIChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.service.capture.ValueExecutorRegistry;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class MistralAIChatLanguageModelProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    public static final SimpleAttributeDefinition RANDOM_SEED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("random-seed", ModelType.INT, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SAFE_PROMPT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"safe-prompt", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(AIAttributeDefinitions.API_KEY, AIAttributeDefinitions.BASE_URL, AIAttributeDefinitions.CONNECT_TIMEOUT, AIAttributeDefinitions.FREQUENCY_PENALTY, AIAttributeDefinitions.LOG_REQUESTS, AIAttributeDefinitions.LOG_RESPONSES, AIAttributeDefinitions.MAX_RETRIES, AIAttributeDefinitions.MAX_TOKEN, AIAttributeDefinitions.MODEL_NAME, AIAttributeDefinitions.PRESENCE_PENALTY, RANDOM_SEED, AIAttributeDefinitions.RESPONSE_FORMAT, SAFE_PROMPT, AIAttributeDefinitions.STOP_SEQUENCES, AIAttributeDefinitions.STREAMING, AIAttributeDefinitions.TEMPERATURE, AIAttributeDefinitions.TOP_P);
    private final ResourceDescriptor descriptor;
    static final String NAME = "mistral-ai-chat-model";
    public static final PathElement PATH = PathElement.pathElement((String)"mistral-ai-chat-model");
    public static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PATH);
    private final ValueExecutorRegistry<String, WildFlyChatModelConfig> registry = ValueExecutorRegistry.newInstance();

    public MistralAIChatLanguageModelProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new MistralAIChatModelProviderServiceConfigurator((ValueRegistry<String, WildFlyChatModelConfig>)this.registry)))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        ChatModelConnectionCheckerOperationHandler.register(resourceRegistration, this.descriptor, this.registry);
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"dev.langchain4j.mistral-ai")});
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

