/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.chat.MistralAIChatLanguageModelProviderRegistrar;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.chat.WildFlyMistralAiChatModelConfig;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class MistralAIChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    MistralAIChatModelProviderServiceConfigurator(ValueRegistry<String, WildFlyChatModelConfig> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asString();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Double frequencyPenalty = AIAttributeDefinitions.FREQUENCY_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final String key = AIAttributeDefinitions.API_KEY.resolveModelAttribute(context, model).asString();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final Integer maxRetries = AIAttributeDefinitions.MAX_RETRIES.resolveModelAttribute(context, model).asIntOrNull();
        final Integer maxToken = AIAttributeDefinitions.MAX_TOKEN.resolveModelAttribute(context, model).asIntOrNull();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final Double presencePenalty = AIAttributeDefinitions.PRESENCE_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final Integer randomSeed = MistralAIChatLanguageModelProviderRegistrar.RANDOM_SEED.resolveModelAttribute(context, model).asIntOrNull();
        final Boolean safePrompt = MistralAIChatLanguageModelProviderRegistrar.SAFE_PROMPT.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean streaming = AIAttributeDefinitions.STREAMING.resolveModelAttribute(context, model).asBooleanOrNull();
        final List stopSequences = AIAttributeDefinitions.STOP_SEQUENCES.unwrap((ExpressionResolver)context, model);
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final Double topP = AIAttributeDefinitions.TOP_P.resolveModelAttribute(context, model).asDoubleOrNull();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        final boolean isObservable = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.opentelemetry");
        Supplier<WildFlyChatModelConfig> factory = new Supplier<WildFlyChatModelConfig>(this){
            final /* synthetic */ MistralAIChatModelProviderServiceConfigurator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WildFlyChatModelConfig get() {
                return new WildFlyMistralAiChatModelConfig().apiKey(key).baseUrl(baseUrl).frequencyPenalty(frequencyPenalty).logRequests(logRequests).logResponses(logResponses).maxRetries(maxRetries).maxTokens(maxToken).modelName(modelName).presencePenalty(presencePenalty).randomSeed(randomSeed).safePrompt(safePrompt).setJson(isJson).setObservable(isObservable).stopSequences(stopSequences).streaming(streaming.booleanValue()).temperature(temperature).timeout(connectTimeOut.longValue()).topP(topP);
            }
        };
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

