/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.mcp.client;

import dev.langchain4j.mcp.client.DefaultMcpClient;
import dev.langchain4j.mcp.client.transport.McpTransport;
import dev.langchain4j.mcp.client.transport.http.HttpMcpTransport;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.mcp.client.McpClientSseProviderRegistrar;
import org.wildfly.extension.ai.mcp.client.WildFlyMcpClient;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class McpClientSseServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        final String scheme = AIAttributeDefinitions.SSL_ENABLED.resolveModelAttribute(context, model).asBoolean() ? "https" : "http";
        final String path = McpClientSseProviderRegistrar.SSE_PATH.resolveModelAttribute(context, model).asString();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        String socketBindingName = McpClientSseProviderRegistrar.SSE_SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        final ServiceDependency outboundSocketBinding = ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)socketBindingName);
        Supplier<WildFlyMcpClient> factory = new Supplier<WildFlyMcpClient>(this){
            final /* synthetic */ McpClientSseServiceConfigurator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WildFlyMcpClient get() {
                try {
                    URI url = new URI(scheme, null, ((OutboundSocketBinding)outboundSocketBinding.get()).getUnresolvedDestinationAddress(), ((OutboundSocketBinding)outboundSocketBinding.get()).getDestinationPort(), path, null, null);
                    HttpMcpTransport transport = new HttpMcpTransport.Builder().logRequests(logRequests.booleanValue()).logResponses(logResponses.booleanValue()).timeout(connectTimeOut > 0L ? Duration.ofMillis(connectTimeOut) : null).sseUrl(url.toString()).build();
                    return new WildFlyMcpClient(new DefaultMcpClient.Builder().transport((McpTransport)transport).clientName(name).build());
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.MCP_CLIENT_CAPABILITY, (Supplier)factory).requires((Consumer)outboundSocketBinding)).blocking()).asActive()).build();
    }
}

