/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.rag.retriever;

import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.injection.WildFlyBeanRegistry;
import org.wildfly.extension.ai.injection.retriever.EmbeddingStoreContentRetrieverConfig;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;
import org.wildfly.extension.ai.rag.retriever.EmbeddingStoreContentRetrieverProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class EmbeddingStoreContentRetrieverProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String embeddingStoreName = EmbeddingStoreContentRetrieverProviderRegistrar.EMBEDDING_STORE.resolveModelAttribute(context, model).asString();
        final String embeddingModelName = EmbeddingStoreContentRetrieverProviderRegistrar.EMBEDDING_MODEL.resolveModelAttribute(context, model).asString();
        final Integer maxResults = EmbeddingStoreContentRetrieverProviderRegistrar.MAX_RESULTS.resolveModelAttribute(context, model).asIntOrNull();
        final Double minScore = EmbeddingStoreContentRetrieverProviderRegistrar.MIN_SCORE.resolveModelAttribute(context, model).asDoubleOrNull();
        final ServiceDependency embeddingStore = ServiceDependency.on(Capabilities.EMBEDDING_STORE_PROVIDER_DESCRIPTOR, (String)embeddingStoreName);
        final ServiceDependency embeddingModel = ServiceDependency.on(Capabilities.EMBEDDING_MODEL_PROVIDER_DESCRIPTOR, (String)embeddingModelName);
        Supplier<WildFlyContentRetrieverConfig> factory = new Supplier<WildFlyContentRetrieverConfig>(this){
            final /* synthetic */ EmbeddingStoreContentRetrieverProviderServiceConfigurator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WildFlyContentRetrieverConfig get() {
                WildFlyBeanRegistry.registerEmbeddingModel((String)embeddingModelName, (EmbeddingModel)((EmbeddingModel)embeddingModel.get()));
                WildFlyBeanRegistry.registerEmbeddingStore((String)embeddingStoreName, (EmbeddingStore)((EmbeddingStore)embeddingStore.get()));
                return new EmbeddingStoreContentRetrieverConfig().embeddingStore(embeddingStoreName).embeddingModel(embeddingModelName).maxResults(maxResults).minScore(minScore);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CONTENT_RETRIEVER_PROVIDER_CAPABILITY, (Supplier)factory).requires((Consumer)embeddingStore)).requires((Consumer)embeddingModel)).blocking()).asActive()).build();
    }
}

