/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.deployment;

import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.store.embedding.EmbeddingStore;
import jakarta.enterprise.inject.spi.Extension;
import java.util.List;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.AILogger;
import org.wildfly.extension.ai.deployment.AIAttachments;
import org.wildfly.extension.ai.injection.WildFlyBeanRegistry;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.memory.WildFlyChatMemoryProviderConfig;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;

public class AIDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        try {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (weldCapability != null && !weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                AILogger.ROOT_LOGGER.cdiRequired();
            }
            List requiredChatModels = deploymentUnit.getAttachmentList(AIAttachments.CHAT_MODELS);
            if (!support.hasCapability("org.wildfly.extension.opentelemetry")) {
                AILogger.ROOT_LOGGER.info("No opentelemetry support available");
            } else {
                AILogger.ROOT_LOGGER.debug("OpenTelemetry is active for AI");
            }
            List chatLanguageModelNames = deploymentUnit.getAttachmentList(AIAttachments.CHAT_MODEL_KEYS);
            List requiredEmbeddingModels = deploymentUnit.getAttachmentList(AIAttachments.EMBEDDING_MODELS);
            List requiredEmbeddingModelNames = deploymentUnit.getAttachmentList(AIAttachments.EMBEDDING_MODEL_KEYS);
            List requiredEmbeddingStores = deploymentUnit.getAttachmentList(AIAttachments.EMBEDDING_STORES);
            List requiredEmbeddingStoreNames = deploymentUnit.getAttachmentList(AIAttachments.EMBEDDING_STORE_KEYS);
            List requiredContentRetrievers = deploymentUnit.getAttachmentList(AIAttachments.CONTENT_RETRIEVERS);
            List requiredContentRetrieverNames = deploymentUnit.getAttachmentList(AIAttachments.CONTENT_RETRIEVER_KEYS);
            List requiredToolProviders = deploymentUnit.getAttachmentList(AIAttachments.TOOL_PROVIDERS);
            List requiredToolProviderNames = deploymentUnit.getAttachmentList(AIAttachments.TOOL_PROVIDER_KEYS);
            List requiredChatMemoryProviders = deploymentUnit.getAttachmentList(AIAttachments.CHAT_MEMORY_PROVIDERS);
            List requiredChatMemoryProviderNames = deploymentUnit.getAttachmentList(AIAttachments.CHAT_MEMORY_PROVIDER_KEYS);
            DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
            if (!(requiredChatModels.isEmpty() && requiredEmbeddingModels.isEmpty() && requiredEmbeddingStores.isEmpty())) {
                int i;
                if (!requiredChatModels.isEmpty()) {
                    for (i = 0; i < requiredChatModels.size(); ++i) {
                        WildFlyBeanRegistry.registerChatModel((String)((String)chatLanguageModelNames.get(i)), (WildFlyChatModelConfig)((WildFlyChatModelConfig)requiredChatModels.get(i)));
                        try {
                            deploymentResourceSupport.getDeploymentSubModel("ai", PathElement.pathElement((String)"chat-model", (String)((String)chatLanguageModelNames.get(i)))).get(AIAttributeDefinitions.STREAMING.getName()).set(((WildFlyChatModelConfig)requiredChatModels.get(i)).isStreaming());
                            continue;
                        }
                        catch (Exception e) {
                            AILogger.ROOT_LOGGER.error(e);
                        }
                    }
                }
                if (!requiredEmbeddingModels.isEmpty()) {
                    for (i = 0; i < requiredEmbeddingModels.size(); ++i) {
                        WildFlyBeanRegistry.registerEmbeddingModel((String)((String)requiredEmbeddingModelNames.get(i)), (EmbeddingModel)((EmbeddingModel)requiredEmbeddingModels.get(i)));
                    }
                }
                if (!requiredEmbeddingStores.isEmpty()) {
                    for (i = 0; i < requiredEmbeddingModels.size(); ++i) {
                        WildFlyBeanRegistry.registerEmbeddingStore((String)((String)requiredEmbeddingStoreNames.get(i)), (EmbeddingStore)((EmbeddingStore)requiredEmbeddingStores.get(i)));
                    }
                }
                if (!requiredContentRetrievers.isEmpty()) {
                    for (i = 0; i < requiredContentRetrievers.size(); ++i) {
                        WildFlyBeanRegistry.registerContentRetriever((String)((String)requiredContentRetrieverNames.get(i)), (WildFlyContentRetrieverConfig)((WildFlyContentRetrieverConfig)requiredContentRetrievers.get(i)));
                    }
                }
                if (!requiredToolProviders.isEmpty()) {
                    for (i = 0; i < requiredToolProviders.size(); ++i) {
                        WildFlyBeanRegistry.registerToolProvider((String)((String)requiredToolProviderNames.get(i)), (ToolProvider)((ToolProvider)requiredToolProviders.get(i)));
                    }
                }
                if (!requiredChatMemoryProviders.isEmpty()) {
                    for (i = 0; i < requiredChatMemoryProviders.size(); ++i) {
                        WildFlyBeanRegistry.registerChatMemoryProvider((String)((String)requiredChatMemoryProviderNames.get(i)), (WildFlyChatMemoryProviderConfig)((WildFlyChatMemoryProviderConfig)requiredChatMemoryProviders.get(i)));
                    }
                }
                for (Extension extension : WildFlyBeanRegistry.getCDIExtensions()) {
                    ((WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).registerExtensionInstance(extension, deploymentUnit);
                }
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException noSuchCapabilityException) {
            // empty catch block
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

