/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.model;

import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class OllamaEmbeddingModelProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asStringOrNull();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        Supplier<EmbeddingModel> factory = new Supplier<EmbeddingModel>(this){
            final /* synthetic */ OllamaEmbeddingModelProviderServiceConfigurator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public EmbeddingModel get() {
                return OllamaEmbeddingModel.builder().baseUrl(baseUrl).logRequests(logRequests).logResponses(logResponses).modelName(modelName).timeout(Duration.ofMillis(connectTimeOut)).build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.EMBEDDING_MODEL_PROVIDER_CAPABILITY, (Supplier)factory).asActive()).build();
    }
}

