/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.store;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.store.ChromaEmbeddingStoreProviderServiceConfigurator;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class ChromaEmbeddingStoreProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    protected static final SimpleAttributeDefinition API_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("api-version", ModelType.STRING, false).setValidator((ParameterValidator)EnumValidator.create(ChromaAPIVersion.class))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition COLLECTION_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("collection-name", ModelType.STRING, true).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DATABASE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("database-name", ModelType.STRING, true).setDefaultValue(new ModelNode("default"))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition TENANT_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("tenant-name", ModelType.STRING, true).setDefaultValue(new ModelNode("default"))).setAllowExpression(true)).build();
    private final ResourceDescriptor descriptor;
    static final String NAME = "chroma-embedding-store";
    public static final PathElement PATH = PathElement.pathElement((String)"chroma-embedding-store");
    public static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PATH);
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(API_VERSION, AIAttributeDefinitions.BASE_URL, COLLECTION_NAME, AIAttributeDefinitions.CONNECT_TIMEOUT, DATABASE_NAME, AIAttributeDefinitions.LOG_REQUESTS, AIAttributeDefinitions.LOG_RESPONSES, TENANT_NAME);

    public ChromaEmbeddingStoreProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new ChromaEmbeddingStoreProviderServiceConfigurator()))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext mrrc) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"dev.langchain4j.chroma")});
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }

    public static enum ChromaAPIVersion {
        V1,
        V2;

    }
}

