/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.store;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.chroma.ChromaApiVersion;
import dev.langchain4j.store.embedding.chroma.ChromaEmbeddingStore;
import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.store.ChromaEmbeddingStoreProviderRegistrar;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ChromaEmbeddingStoreProviderServiceConfigurator
implements ResourceServiceConfigurator {
    ChromaEmbeddingStoreProviderServiceConfigurator() {
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String version = ChromaEmbeddingStoreProviderRegistrar.API_VERSION.resolveModelAttribute(context, model).asString();
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asString();
        final String collectionName = ChromaEmbeddingStoreProviderRegistrar.COLLECTION_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLongOrNull();
        final String databaseName = ChromaEmbeddingStoreProviderRegistrar.DATABASE_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final String tenantName = ChromaEmbeddingStoreProviderRegistrar.TENANT_NAME.resolveModelAttribute(context, model).asStringOrNull();
        Supplier<EmbeddingStore<TextSegment>> factory = new Supplier<EmbeddingStore<TextSegment>>(this){
            final /* synthetic */ ChromaEmbeddingStoreProviderServiceConfigurator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public EmbeddingStore<TextSegment> get() {
                return ChromaEmbeddingStore.builder().baseUrl(baseUrl).collectionName(collectionName).databaseName(databaseName).logRequests(logRequests.booleanValue()).logResponses(logResponses.booleanValue()).tenantName(tenantName).timeout(connectTimeOut == null ? null : Duration.ofMillis(connectTimeOut)).apiVersion(ChromaApiVersion.valueOf((String)version)).build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY, (Supplier)factory).blocking()).startWhen(Installer.StartWhen.INSTALLED)).build();
    }
}

