/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.deployment;

import io.undertow.Handlers;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.extension.mcp.Capabilities;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.McpEndpointConfiguration;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.deployment.MCPAttachements;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.server.McpServerSentConnectionCallBack;
import org.wildfly.extension.mcp.server.MessagesHttpHandler;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcClientConfigurationBuilder;
import org.wildfly.security.http.oidc.OidcClientContext;
import org.wildfly.security.http.oidc.OidcMechanismFactory;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class McpSseHandlerServiceInstaller
implements DeploymentServiceInstaller {
    public void install(DeploymentPhaseContext context) {
        final DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        ModelNode model = ((DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubsystemModel("undertow");
        WildFlyMCPRegistry registry = (WildFlyMCPRegistry)deploymentUnit.getAttachment(MCPAttachements.MCP_REGISTRY_METADATA);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        String serverName = model.get(DeploymentDefinition.SERVER.getName()).asString();
        String hostName = model.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
        String webContext = model.get(DeploymentDefinition.CONTEXT_ROOT.getName()).asString();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory = this.getHttpServerAuthenticationMechanismFactory(deploymentUnit);
        final boolean oidcSecured = httpServerAuthenticationMechanismFactory != null;
        final ServiceDependency securityDomain = oidcSecured ? ServiceDependency.on((ServiceName)VirtualDomainMarkerUtility.virtualDomainName((DeploymentUnit)deploymentUnit)) : null;
        McpEndpointConfiguration configuration = (McpEndpointConfiguration)deploymentUnit.getAttachment(MCPAttachements.MCP_ENDPOINT_CONFIGURATION);
        final String messagesEndpoint = "/".equals(webContext) ? webContext + configuration.getMessagesPath() : webContext + "/" + configuration.getMessagesPath();
        ConnectionManager connectionManager = new ConnectionManager();
        final McpServerSentConnectionCallBack mcpServerSentConnectionCallBack = new McpServerSentConnectionCallBack(messagesEndpoint, connectionManager);
        final MessagesHttpHandler messagesHttpHandler = new MessagesHttpHandler(connectionManager, registry, (ClassLoader)classLoader, serverName, deploymentUnit.getName());
        final String ssePath = "/".equals(webContext) ? webContext + configuration.getSsePath() : webContext + "/" + configuration.getSsePath();
        Runnable start = new Runnable(){

            @Override
            public void run() {
                if (oidcSecured) {
                    HttpAuthenticationFactory httpAuthenticationFactory = HttpAuthenticationFactory.builder().setFactory(McpSseHandlerServiceInstaller.this.getHttpServerAuthenticationMechanismFactory(deploymentUnit)).setSecurityDomain((SecurityDomain)securityDomain.get()).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)MechanismConfiguration.EMPTY)).build();
                    ((Host)host.get()).registerHandler(ssePath, McpSseHandlerServiceInstaller.this.secureHandler((HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)mcpServerSentConnectionCallBack), httpAuthenticationFactory));
                    ((Host)host.get()).registerHandler(messagesEndpoint, McpSseHandlerServiceInstaller.this.secureHandler(messagesHttpHandler, httpAuthenticationFactory));
                } else {
                    ((Host)host.get()).registerHandler(ssePath, (HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)mcpServerSentConnectionCallBack));
                    ((Host)host.get()).registerHandler(messagesEndpoint, (HttpHandler)messagesHttpHandler);
                }
                MCPLogger.ROOT_LOGGER.endpointRegistered(ssePath, ((Host)host.get()).getName());
            }
        };
        Runnable stop = new Runnable(){

            @Override
            public void run() {
                ((Host)host.get()).unregisterHandler(ssePath);
                ((Host)host.get()).unregisterHandler(messagesEndpoint);
                MCPLogger.ROOT_LOGGER.endpointUnregistered(ssePath, ((Host)host.get()).getName());
            }
        };
        if (oidcSecured) {
            ((ServiceInstaller)((ServiceInstaller.Builder)((ServiceInstaller.Builder)ServiceInstaller.builder((Runnable)start, (Runnable)stop).requires(List.of(host, ServiceDependency.on(Capabilities.MCP_SERVER_PROVIDER_DESCRIPTOR), securityDomain))).asActive()).build()).install(context);
        } else {
            ((ServiceInstaller)((ServiceInstaller.Builder)((ServiceInstaller.Builder)ServiceInstaller.builder((Runnable)start, (Runnable)stop).requires(List.of(host, ServiceDependency.on(Capabilities.MCP_SERVER_PROVIDER_DESCRIPTOR)))).asActive()).build()).install(context);
        }
    }

    private HttpServerAuthenticationMechanismFactory getHttpServerAuthenticationMechanismFactory(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return null;
        }
        String json = this.getJsonConfiguration(warMetaData);
        if (json != null) {
            OidcClientConfiguration oidcClientConfiguration = OidcClientConfigurationBuilder.build((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
            oidcClientConfiguration.setBearerOnly(true);
            OidcClientContext oidcClientContext = new OidcClientContext(oidcClientConfiguration);
            return new OidcMechanismFactory(oidcClientContext);
        }
        return null;
    }

    private String getJsonConfiguration(WarMetaData warMetaData) {
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        for (ParamValueMetaData param : webMetaData.getContextParams()) {
            if (!"org.wildfly.security.http.oidc.json.config".equals(param.getParamName())) continue;
            return param.getParamValue();
        }
        return null;
    }

    private HttpHandler secureHandler(HttpHandler handler, HttpAuthenticationFactory httpAuthenticationFactory) {
        AuthenticationCallHandler domainHandler = new AuthenticationCallHandler(handler);
        domainHandler = new AuthenticationConstraintHandler((HttpHandler)domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext((HttpHandler)domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange2;
                super(httpServerExchange);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }
}

