/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.api;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wildfly.extension.mcp.api.McpConnection;

public class ConnectionManager {
    private final ConcurrentMap<String, McpConnection> connections = new ConcurrentHashMap<String, McpConnection>();

    public McpConnection get(String id) {
        return (McpConnection)this.connections.get(id);
    }

    public void add(McpConnection connection) {
        this.connections.put(connection.id(), connection);
    }

    public boolean remove(String id) {
        McpConnection connection = (McpConnection)this.connections.remove(id);
        if (connection != null) {
            try {
                connection.close();
                return true;
            }
            catch (IOException ex) {
                Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }
}

