/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.api;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.wildfly.extension.mcp.api.Messages;
import org.wildfly.extension.mcp.api.Responder;

public class JsonRPC {
    public static final String VERSION = "2.0";
    public static final int RESOURCE_NOT_FOUND = -32002;
    public static final int INTERNAL_ERROR = -32603;
    public static final int INVALID_PARAMS = -32602;
    public static final int METHOD_NOT_FOUND = -32601;
    public static final int INVALID_REQUEST = -32600;
    public static final int PARSE_ERROR = -32700;

    public static boolean validate(JsonObject message, Responder responder) {
        String id = message.get((Object)"id") == null ? null : ((JsonValue)message.get((Object)"id")).toString();
        String jsonrpc = message.getString("jsonrpc");
        if (!VERSION.equals(jsonrpc)) {
            responder.sendError(id, -32600, "Invalid jsonrpc version: " + jsonrpc);
            return false;
        }
        if (!Messages.isResponse(message) && message.get((Object)"method") == null) {
            responder.sendError(id, -32601, "Method not set");
            return false;
        }
        return true;
    }

    public static JsonObjectBuilder convertMap(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> info : map.entrySet()) {
            Object value = info.getValue();
            if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                builder.add(info.getKey(), bigDecimal);
                continue;
            }
            if (value instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)value;
                builder.add(info.getKey(), bigInteger);
                continue;
            }
            if (value instanceof JsonValue) {
                JsonValue jsonValue = (JsonValue)value;
                builder.add(info.getKey(), jsonValue);
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                builder.add(info.getKey(), string);
                continue;
            }
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                builder.add(info.getKey(), integer.intValue());
                continue;
            }
            if (value instanceof Long) {
                Long aLong = (Long)value;
                builder.add(info.getKey(), aLong.longValue());
                continue;
            }
            if (value instanceof Double) {
                Double aDouble = (Double)value;
                builder.add(info.getKey(), aDouble.doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                Boolean aBoolean = (Boolean)value;
                builder.add(info.getKey(), aBoolean.booleanValue());
                continue;
            }
            if (value instanceof Map) {
                Map map1 = (Map)value;
                builder.add(info.getKey(), JsonRPC.convertMap(map1));
                continue;
            }
            builder.addNull(info.getKey());
        }
        return builder;
    }
}

