/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.extension.mcp.api.McpConnection;
import org.wildfly.extension.mcp.api.Responder;
import org.wildfly.extension.mcp.injection.MCPLogger;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.injection.tool.McpFeatureMetadata;
import org.wildfly.extension.mcp.injection.tool.McpResource;
import org.wildfly.extension.mcp.injection.tool.MethodMetadata;
import org.wildfly.extension.mcp.server.McpException;
import org.wildfly.extension.mcp.server.ToolMessageHandler;
import org.wildfly.mcp.api.BlobResourceContents;
import org.wildfly.mcp.api.ContentMapper;
import org.wildfly.mcp.api.ResourceContents;
import org.wildfly.mcp.api.TextResourceContents;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ResourceMessageHandler {
    private final SchemaGenerator schemaGenerator = new SchemaGenerator(new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).build());
    private final WildFlyMCPRegistry registry;
    private final ObjectMapper mapper;
    private final ClassLoader classLoader;
    private ManagedExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceMessageHandler(WildFlyMCPRegistry registry, ClassLoader classLoader) {
        this.registry = registry;
        this.mapper = new ObjectMapper();
        this.classLoader = classLoader;
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.executorService = (ManagedExecutorService)context.lookup("java:jboss/ee/concurrency/executor/default");
        }
        catch (NamingException ex) {
            MCPLogger.ROOT_LOGGER.error((Object)"Error accessing managed executor service ", (Throwable)ex);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ex) {
                    MCPLogger.ROOT_LOGGER.debug((Object)"Error closing initial context", (Throwable)ex);
                }
            }
        }
    }

    void resourcesList(JsonObject message, Responder responder) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        MCPLogger.ROOT_LOGGER.debugf("List resources [id: %s]", (Object)id);
        JsonArrayBuilder resources = Json.createArrayBuilder();
        for (McpFeatureMetadata resourceMetadata : this.registry.listResources()) {
            JsonObjectBuilder resource = Json.createObjectBuilder().add("name", resourceMetadata.name()).add("description", resourceMetadata.description()).add("uri", resourceMetadata.method().uri()).add("mimeType", resourceMetadata.method().mimeType());
            resources.add(resource);
        }
        responder.sendResult(id, Json.createObjectBuilder().add("resources", resources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resourceCall(JsonObject message, final Responder responder, McpConnection connection) {
        McpFeatureMetadata metadata;
        final String id = ((JsonValue)message.get((Object)"id")).toString();
        JsonObject params = ((JsonValue)message.get((Object)"params")).asJsonObject();
        final String resourceUri = params.getString("uri");
        MCPLogger.ROOT_LOGGER.debugf("Call resource %s [id: %s]", (Object)resourceUri, (Object)id);
        final HashMap<String, JsonValue> args = new HashMap<String, JsonValue>();
        JsonObject arguments = params.getJsonObject("arguments");
        if (arguments != null) {
            for (String key : arguments.keySet()) {
                args.put(key, (JsonValue)arguments.get((Object)key));
            }
        }
        if ((metadata = this.registry.getResource(resourceUri)) == null) {
            responder.sendError(id, -32602, "Invalid resource name: " + resourceUri);
            return;
        }
        ClassLoader prevCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            connection.task(this.executorService.submit(new Runnable(){
                final /* synthetic */ ResourceMessageHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Object result;
                        MethodMetadata methodMetadata;
                        block17: {
                            methodMetadata = metadata.method();
                            Class<?> clazz = this.this$0.classLoader.loadClass(methodMetadata.declaringClassName());
                            Instance beanInstance = CDI.current().select(clazz, new Annotation[]{McpResource.McpResourceLiteral.INSTANCE});
                            result = null;
                            if (beanInstance.isResolvable()) {
                                MCPLogger.ROOT_LOGGER.info((Object)("We have found the Singleton instance of the resource" + resourceUri));
                                try {
                                    if (args.isEmpty()) {
                                        result = this.this$0.registry.getResourceInvoker(resourceUri).invoke(beanInstance.get());
                                        break block17;
                                    }
                                    ArrayList<Object> preparedArguments = new ArrayList<Object>(Arrays.asList(ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper)));
                                    preparedArguments.add(0, beanInstance.get());
                                    result = this.this$0.registry.getResourceInvoker(resourceUri).invokeWithArguments(preparedArguments);
                                }
                                catch (Throwable ex) {
                                    MCPLogger.ROOT_LOGGER.error((Object)("Error invoking resource " + resourceUri), ex);
                                    responder.sendError(id, -32603, ex.getMessage());
                                }
                            } else {
                                MCPLogger.ROOT_LOGGER.warn((Object)("We have NOT found the Singleton instance of the resource" + resourceUri));
                                Method method = clazz.getMethod(methodMetadata.name(), methodMetadata.argumentTypes());
                                if (Modifier.isStatic(method.getModifiers())) {
                                    result = method.invoke(null, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                } else {
                                    Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
                                    Object instance = defaultConstructor.newInstance(new Object[0]);
                                    result = method.invoke(instance, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                }
                            }
                        }
                        Collection contents = ContentMapper.processResultAsResourceText((String)methodMetadata.uri(), (Object)result);
                        JsonArrayBuilder jsonContent = Json.createArrayBuilder();
                        for (ResourceContents content : contents) {
                            JsonObjectBuilder contentResource = Json.createObjectBuilder();
                            switch (content.type()) {
                                case BLOB: {
                                    String blobMimeType;
                                    BlobResourceContents blob = content.asBlob();
                                    contentResource.add("uri", blob.uri());
                                    String string = blobMimeType = blob.mimeType() == null ? methodMetadata.mimeType() : blob.mimeType();
                                    if (blobMimeType != null) {
                                        contentResource.add("mimeType", blobMimeType);
                                    }
                                    contentResource.add("mimeType", blob.mimeType() == null ? methodMetadata.mimeType() : blob.mimeType());
                                    contentResource.add("text", blob.blob());
                                    break;
                                }
                                case TEXT: {
                                    String textMimeType;
                                    TextResourceContents text = content.asText();
                                    contentResource.add("uri", text.uri());
                                    String string = textMimeType = text.mimeType() == null ? methodMetadata.mimeType() : text.mimeType();
                                    if (textMimeType != null) {
                                        contentResource.add("mimeType", textMimeType);
                                    }
                                    contentResource.add("text", text.text());
                                }
                            }
                            jsonContent.add(contentResource);
                        }
                        JsonObjectBuilder builder = Json.createObjectBuilder();
                        builder.add("contents", jsonContent);
                        responder.sendResult(id, builder);
                    }
                    catch (McpException e) {
                        MCPLogger.ROOT_LOGGER.error((Object)e);
                        responder.sendError(id, e.getJsonRpcError(), e.getMessage());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        MCPLogger.ROOT_LOGGER.error((Object)("Error invoking resource " + resourceUri), (Throwable)ex);
                        responder.sendError(id, -32603, ex.getMessage());
                    }
                }
            }));
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)prevCL);
        }
    }
}

