/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.InputStream;
import java.util.Arrays;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.api.JsonRPC;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.server.McpMessageHandler;
import org.wildfly.extension.mcp.server.McpStreamableConnectionCallBack;
import org.wildfly.extension.mcp.server.ServerSentEventResponder;

public class StreamableHttpHandler
implements HttpHandler {
    private final ConnectionManager connectionManager;
    static McpMessageHandler handler;
    private final ServerSentEventHandler sseHandler;

    public StreamableHttpHandler(ConnectionManager connectionManager, WildFlyMCPRegistry registry, ClassLoader classLoader, String serverName, String applicationName, ServerSentEventHandler sseHandler) {
        this.connectionManager = connectionManager;
        this.sseHandler = sseHandler;
        handler = new McpMessageHandler(connectionManager, registry, classLoader, serverName, applicationName);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (Methods.GET.equals(exchange.getRequestMethod())) {
            this.sseHandler.handleRequest(exchange);
            return;
        }
        if (!Methods.POST.equals(exchange.getRequestMethod())) {
            MCPLogger.ROOT_LOGGER.invalidHttpMethod(exchange.getRequestMethod().toString());
            exchange.setStatusCode(405).getResponseHeaders().add(Headers.ALLOW, "POST");
            exchange.endExchange();
            return;
        }
        HeaderValues accepts = exchange.getRequestHeaders().get(Headers.ACCEPT);
        if (!accepts.contains((Object)"application/json") || !accepts.contains((Object)"text/event-stream")) {
            MCPLogger.ROOT_LOGGER.invalidAcceptHeaders(Arrays.toString(accepts.toArray()));
            exchange.setStatusCode(400);
            exchange.endExchange();
            return;
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        exchange.startBlocking();
        JsonReader reader = Json.createReader((InputStream)exchange.getInputStream());
        JsonObject content = reader.readObject();
        MCPLogger.ROOT_LOGGER.debug("Received message from client: %s".formatted(content));
        String connectionId = exchange.getRequestHeaders().getFirst(ConnectionManager.MCP_SESSION_ID_HEADER);
        if (connectionId == null) {
            connectionId = this.connectionManager.id();
            exchange.putAttachment(McpStreamableConnectionCallBack.SESSION_ID, (Object)connectionId);
            exchange.putAttachment(McpStreamableConnectionCallBack.JSON_PAYLOAD, (Object)content);
            exchange.setStatusCode(200);
            exchange.getResponseHeaders().put(ConnectionManager.MCP_SESSION_ID_HEADER, connectionId);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/event-stream");
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Origin"), "*");
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Access-Control-Expose-Headers"), "mcp-session-id");
            exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "no-cache");
            this.sseHandler.handleRequest(exchange);
            return;
        }
        ServerSentEventResponder connection = (ServerSentEventResponder)this.connectionManager.get(connectionId);
        JsonRPC.validate(content, connection);
        exchange.getResponseHeaders().put(ConnectionManager.MCP_SESSION_ID_HEADER, connectionId);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/event-stream");
        exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Origin"), "*");
        exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Access-Control-Expose-Headers"), "mcp-session-id");
        exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "no-cache");
        handler.handle(content, connection, connection);
    }
}

