package org.wildfly.extension.mcp;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import org.jboss.as.server.deployment.DeploymentUnit;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-10-10T12:45:55+0200")
public class MCPLogger_$logger extends DelegatingBasicLogger implements MCPLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MCPLogger_$logger.class.getName();
    public MCPLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cdiRequired() {
        super.log.logf(FQCN, WARN, null, cdiRequired$str());
    }
    protected String cdiRequired$str() {
        return "WFMCP00001: The deployment does not have Jakarta Dependency Injection enabled.";
    }
    protected String unableToResolveAnnotationIndex$str() {
        return "WFMCP00002: Unable to resolve annotation index for deployment unit: %s";
    }
    @Override
    public final DeploymentUnitProcessingException unableToResolveAnnotationIndex(final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), unableToResolveAnnotationIndex$str(), deploymentUnit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String chatLanguageModelServiceUnavailable$str() {
        return "WFMCP00003: Couldn't access the Chat Language Model called %s";
    }
    @Override
    public final OperationFailedException chatLanguageModelServiceUnavailable(final String chatLanguageModelName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), chatLanguageModelServiceUnavailable$str(), chatLanguageModelName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void endpointRegistered(final String path, final String hostName) {
        super.log.logf(FQCN, INFO, null, endpointRegistered$str(), path, hostName);
    }
    protected String endpointRegistered$str() {
        return "WFMCP00004: Registered MCP endpoint '%s' for host '%s'";
    }
    @Override
    public final void endpointUnregistered(final String path, final String hostName) {
        super.log.logf(FQCN, INFO, null, endpointUnregistered$str(), path, hostName);
    }
    protected String endpointUnregistered$str() {
        return "WFMCP00005: Unregistered MCP endpoint '%s' for host '%s'";
    }
    protected String failedToResolveModule$str() {
        return "WFMCP00006: Failed to resolve module for deployment %s";
    }
    @Override
    public final DeploymentUnitProcessingException failedToResolveModule(final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToResolveModule$str(), deploymentUnit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void invalidHttpMethod(final String method) {
        super.log.logf(FQCN, ERROR, null, invalidHttpMethod$str(), method);
    }
    protected String invalidHttpMethod$str() {
        return "WFMCP00007: Invalid Method: %s";
    }
    @Override
    public final void invalidAcceptHeaders(final String header) {
        super.log.logf(FQCN, ERROR, null, invalidAcceptHeaders$str(), header);
    }
    protected String invalidAcceptHeaders$str() {
        return "WFMCP00008: Invalid Accept header: %s";
    }
}
