/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.mcp.MCPLogger;

public class MCPLogger_$logger
extends DelegatingBasicLogger
implements MCPLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MCPLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MCPLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cdiRequired() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cdiRequired$str(), new Object[0]);
    }

    protected String cdiRequired$str() {
        return "WFMCP00001: The deployment does not have Jakarta Dependency Injection enabled.";
    }

    protected String unableToResolveAnnotationIndex$str() {
        return "WFMCP00002: Unable to resolve annotation index for deployment unit: %s";
    }

    @Override
    public final DeploymentUnitProcessingException unableToResolveAnnotationIndex(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.unableToResolveAnnotationIndex$str(), deploymentUnit));
        MCPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String chatLanguageModelServiceUnavailable$str() {
        return "WFMCP00003: Couldn't access the Chat Language Model called %s";
    }

    @Override
    public final OperationFailedException chatLanguageModelServiceUnavailable(String chatLanguageModelName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.chatLanguageModelServiceUnavailable$str(), chatLanguageModelName));
        MCPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void endpointRegistered(String path, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointRegistered$str(), (Object)path, (Object)hostName);
    }

    protected String endpointRegistered$str() {
        return "WFMCP00004: Registered MCP endpoint '%s' for host '%s'";
    }

    @Override
    public final void endpointUnregistered(String path, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointUnregistered$str(), (Object)path, (Object)hostName);
    }

    protected String endpointUnregistered$str() {
        return "WFMCP00005: Unregistered MCP endpoint '%s' for host '%s'";
    }

    protected String failedToResolveModule$str() {
        return "WFMCP00006: Failed to resolve module for deployment %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToResolveModule(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToResolveModule$str(), deploymentUnit));
        MCPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void invalidHttpMethod(String method) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidHttpMethod$str(), (Object)method);
    }

    protected String invalidHttpMethod$str() {
        return "WFMCP00007: Invalid Method: %s";
    }

    @Override
    public final void invalidAcceptHeaders(String header) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidAcceptHeaders$str(), (Object)header);
    }

    protected String invalidAcceptHeaders$str() {
        return "WFMCP00008: Invalid Accept header: %s";
    }
}

