/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.api;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.function.Function;
import org.apache.sshd.common.util.io.functors.Invoker;
import org.wildfly.extension.mcp.api.ExecutionModel;
import org.wildfly.extension.mcp.api.FeatureArgument;
import org.wildfly.extension.mcp.api.FeatureMethodInfo;

public record FeatureMetadata<M>(Feature feature, FeatureMethodInfo info, Invoker<Object, Object> invoker, ExecutionModel executionModel, Function<Object, M> resultMapper) implements Comparable<FeatureMetadata<M>>
{
    @Override
    public int compareTo(FeatureMetadata<M> o) {
        return this.info.name().compareTo(o.info.name());
    }

    public JsonObject asJson() {
        JsonObjectBuilder json = Json.createObjectBuilder().add("name", this.info.name()).add("description", this.info.description());
        if (null != this.feature) {
            switch (this.feature.ordinal()) {
                case 0: {
                    JsonArrayBuilder arguments = Json.createArrayBuilder();
                    for (FeatureArgument arg : this.info.serializedArguments()) {
                        arguments.add((JsonValue)arg.asJson());
                    }
                    json.add("arguments", arguments);
                    break;
                }
                case 2: {
                    json.add("uri", this.info.uri()).add("mimeType", this.info.mimeType());
                    break;
                }
                case 3: {
                    json.add("uriTemplate", this.info.uri()).add("mimeType", this.info.mimeType());
                    break;
                }
            }
        }
        return json.build();
    }

    public static enum Feature {
        PROMPT,
        TOOL,
        RESOURCE,
        RESOURCE_TEMPLATE,
        PROMPT_COMPLETE,
        RESOURCE_TEMPLATE_COMPLETE;


        public boolean requiresUri() {
            return this == RESOURCE || this == RESOURCE_TEMPLATE;
        }
    }
}

