/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.server.ServerSentEventResponder;

public class McpServerSentConnectionCallBack
implements ServerSentEventConnectionCallback {
    private final String endpoint;
    private final ConnectionManager connectionManager;

    public McpServerSentConnectionCallBack(String endpoint, ConnectionManager connectionManager) {
        this.endpoint = endpoint;
        this.connectionManager = connectionManager;
    }

    public void connected(ServerSentEventConnection sseConnection, String lastEventId) {
        String id = this.connectionManager.id();
        MCPLogger.ROOT_LOGGER.debug("Client connection initialized [%s]".formatted(id));
        String endpointPath = this.endpoint + "/" + id;
        sseConnection.getResponseHeaders().add(ConnectionManager.MCP_SESSION_ID_HEADER, id);
        ServerSentEventResponder responder = new ServerSentEventResponder(sseConnection, id);
        this.connectionManager.add(responder);
        MCPLogger.ROOT_LOGGER.debug("Sending endpoint [%s]".formatted(endpointPath));
        responder.send("endpoint", endpointPath);
    }
}

