/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.util.AttachmentKey;
import jakarta.json.JsonObject;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.api.JsonRPC;
import org.wildfly.extension.mcp.server.ServerSentEventResponder;
import org.wildfly.extension.mcp.server.StreamableHttpHandler;

public class McpStreamableConnectionCallBack
implements ServerSentEventConnectionCallback {
    public static final AttachmentKey<JsonObject> JSON_PAYLOAD = AttachmentKey.create(JsonObject.class);
    public static final AttachmentKey<String> SESSION_ID = AttachmentKey.create(String.class);
    private final ConnectionManager connectionManager;

    public McpStreamableConnectionCallBack(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void connected(ServerSentEventConnection sseConnection, String lastEventId) {
        String id = (String)sseConnection.getAttachment(SESSION_ID);
        MCPLogger.ROOT_LOGGER.debug("Client connection initialized [%s]".formatted(id));
        sseConnection.getResponseHeaders().add(ConnectionManager.MCP_SESSION_ID_HEADER, id);
        ServerSentEventResponder connection = new ServerSentEventResponder(sseConnection, id);
        this.connectionManager.add(connection);
        JsonObject content = (JsonObject)sseConnection.getAttachment(JSON_PAYLOAD);
        MCPLogger.ROOT_LOGGER.debug("Received message from client: %s".formatted(content));
        JsonRPC.validate(content, connection);
        StreamableHttpHandler.handler.handle(content, connection, connection);
    }
}

