/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.extension.mcp.api.McpConnection;
import org.wildfly.extension.mcp.api.Responder;
import org.wildfly.extension.mcp.injection.MCPLogger;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.injection.tool.ArgumentMetadata;
import org.wildfly.extension.mcp.injection.tool.McpFeatureMetadata;
import org.wildfly.extension.mcp.injection.tool.McpPrompt;
import org.wildfly.extension.mcp.injection.tool.MethodMetadata;
import org.wildfly.extension.mcp.server.McpException;
import org.wildfly.extension.mcp.server.ToolMessageHandler;
import org.wildfly.mcp.api.ContentMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

public class PromptMessageHandler {
    private final WildFlyMCPRegistry registry;
    private final ObjectMapper mapper;
    private final ClassLoader classLoader;
    private ManagedExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PromptMessageHandler(WildFlyMCPRegistry registry, ClassLoader classLoader) {
        this.registry = registry;
        this.mapper = new ObjectMapper();
        this.classLoader = classLoader;
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.executorService = (ManagedExecutorService)context.lookup("java:jboss/ee/concurrency/executor/default");
        }
        catch (NamingException ex) {
            MCPLogger.ROOT_LOGGER.error((Object)"Error accessing managed executor service ", (Throwable)ex);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ex) {
                    MCPLogger.ROOT_LOGGER.debug((Object)"Error closing initial context", (Throwable)ex);
                }
            }
        }
    }

    void promptsList(JsonObject message, Responder responder) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        MCPLogger.ROOT_LOGGER.debugf("List tools [id: %s]", (Object)id);
        JsonArrayBuilder prompts = Json.createArrayBuilder();
        for (McpFeatureMetadata promptMetadata : this.registry.listPrompts()) {
            JsonObjectBuilder promptJson = Json.createObjectBuilder().add("name", promptMetadata.name()).add("description", promptMetadata.description());
            JsonArrayBuilder arguments = Json.createArrayBuilder();
            for (ArgumentMetadata arg : promptMetadata.arguments()) {
                JsonObjectBuilder argJson = Json.createObjectBuilder().add("name", arg.name()).add("description", arg.description()).add("required", arg.required());
                arguments.add(argJson);
            }
            promptJson.add("arguments", arguments);
            prompts.add(promptJson);
        }
        responder.sendResult(id, Json.createObjectBuilder().add("prompts", prompts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptsGet(JsonObject message, final Responder responder, McpConnection connection) {
        McpFeatureMetadata metadata;
        final String id = ((JsonValue)message.get((Object)"id")).toString();
        JsonObject params = ((JsonValue)message.get((Object)"params")).asJsonObject();
        final String promptName = params.getString("name");
        MCPLogger.ROOT_LOGGER.debugf("Call prompt %s [id: %s]", (Object)promptName, (Object)id);
        final HashMap<String, JsonValue> args = new HashMap<String, JsonValue>();
        JsonObject arguments = params.getJsonObject("arguments");
        if (arguments != null) {
            for (String key : arguments.keySet()) {
                args.put(key, (JsonValue)arguments.get((Object)key));
            }
        }
        if ((metadata = this.registry.getPrompt(promptName)) == null) {
            responder.sendError(id, -32602, "Invalid prompt name: " + promptName);
            return;
        }
        ClassLoader prevCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            connection.task(this.executorService.submit(new Runnable(){
                final /* synthetic */ PromptMessageHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Object result;
                        MethodMetadata methodMetadata;
                        block20: {
                            methodMetadata = metadata.method();
                            Class<?> clazz = this.this$0.classLoader.loadClass(methodMetadata.declaringClassName());
                            Instance beanInstance = CDI.current().select(clazz, new Annotation[]{McpPrompt.McpPromptLiteral.INSTANCE});
                            result = null;
                            if (beanInstance.isResolvable()) {
                                MCPLogger.ROOT_LOGGER.debug((Object)("We have found the Singleton instance of the prompt" + promptName));
                                try {
                                    if (args.isEmpty()) {
                                        result = this.this$0.registry.getPromptInvoker(promptName).invoke(beanInstance.get());
                                        break block20;
                                    }
                                    ArrayList<Object> preparedArguments = new ArrayList<Object>(Arrays.asList(ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper)));
                                    preparedArguments.add(0, beanInstance.get());
                                    result = this.this$0.registry.getPromptInvoker(promptName).invokeWithArguments(preparedArguments);
                                }
                                catch (Throwable ex) {
                                    MCPLogger.ROOT_LOGGER.error((Object)("Error invoking tool " + promptName), ex);
                                    responder.sendError(id, -32603, ex.getMessage());
                                }
                            } else {
                                MCPLogger.ROOT_LOGGER.warn((Object)("We have NOT found the Singleton instance of the prompt" + promptName));
                                Method method = clazz.getMethod(methodMetadata.name(), methodMetadata.argumentTypes());
                                if (Modifier.isStatic(method.getModifiers())) {
                                    result = method.invoke(null, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                } else {
                                    Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
                                    Object instance = defaultConstructor.newInstance(new Object[0]);
                                    result = method.invoke(instance, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                }
                            }
                        }
                        Collection promptMessages = ContentMapper.processResultAsPromptMessage((Object)result);
                        try (StringWriter out = new StringWriter();){
                            this.this$0.mapper.writeValue((Writer)out, (Object)promptMessages);
                            try (StringReader in = new StringReader(out.toString());){
                                JsonObjectBuilder builder = Json.createObjectBuilder();
                                builder.add("description", methodMetadata.description());
                                builder.add("messages", (JsonValue)Json.createReader((Reader)in).readArray());
                                responder.sendResult(id, builder);
                            }
                        }
                    }
                    catch (McpException e) {
                        MCPLogger.ROOT_LOGGER.error((Object)e);
                        responder.sendError(id, e.getJsonRpcError(), e.getMessage());
                    }
                    catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        MCPLogger.ROOT_LOGGER.error((Object)("Error invoking prompt " + promptName), (Throwable)ex);
                        responder.sendError(id, -32603, ex.getMessage());
                    }
                }
            }));
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)prevCL);
        }
    }
}

