/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.extension.mcp.api.McpConnection;
import org.wildfly.extension.mcp.api.Responder;
import org.wildfly.extension.mcp.injection.MCPLogger;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.injection.tool.ArgumentMetadata;
import org.wildfly.extension.mcp.injection.tool.McpFeatureMetadata;
import org.wildfly.extension.mcp.injection.tool.McpTool;
import org.wildfly.extension.mcp.injection.tool.MethodMetadata;
import org.wildfly.extension.mcp.server.McpException;
import org.wildfly.mcp.api.ContentMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ToolMessageHandler {
    private final SchemaGenerator schemaGenerator = new SchemaGenerator(new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).build());
    private final WildFlyMCPRegistry registry;
    private final ObjectMapper mapper;
    private final ClassLoader classLoader;
    private ManagedExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ToolMessageHandler(WildFlyMCPRegistry registry, ClassLoader classLoader) {
        this.registry = registry;
        this.mapper = new ObjectMapper();
        this.classLoader = classLoader;
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.executorService = (ManagedExecutorService)context.lookup("java:jboss/ee/concurrency/executor/default");
        }
        catch (NamingException ex) {
            MCPLogger.ROOT_LOGGER.error((Object)"Error accessing managed executor service ", (Throwable)ex);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ex) {
                    MCPLogger.ROOT_LOGGER.debug((Object)"Error closing initial context", (Throwable)ex);
                }
            }
        }
    }

    void toolsList(JsonObject message, Responder responder) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        MCPLogger.ROOT_LOGGER.debugf("List tools [id: %s]", (Object)id);
        JsonArrayBuilder tools = Json.createArrayBuilder();
        for (McpFeatureMetadata toolMetadata : this.registry.listTools()) {
            JsonObjectBuilder tool = Json.createObjectBuilder().add("name", toolMetadata.name()).add("description", toolMetadata.description());
            JsonObjectBuilder properties = Json.createObjectBuilder();
            JsonArrayBuilder required = Json.createArrayBuilder();
            for (ArgumentMetadata a : toolMetadata.arguments()) {
                properties.add(a.name(), (JsonValue)this.generateSchema(a.type(), a));
                if (!a.required()) continue;
                required.add(a.name());
            }
            tool.add("inputSchema", Json.createObjectBuilder().add("type", "object").add("properties", properties).add("required", required));
            tools.add(tool);
        }
        responder.sendResult(id, Json.createObjectBuilder().add("tools", tools));
    }

    private JsonObject generateSchema(Type type, ArgumentMetadata argument) {
        ObjectNode jsonNode = this.schemaGenerator.generateSchema(type, new Type[0]);
        if (jsonNode.isObject()) {
            ObjectNode objectNode = jsonNode;
            objectNode.remove("$schema");
            if (argument.description() != null && !argument.description().isBlank()) {
                objectNode.put("description", argument.description());
            }
        }
        return Json.createReader((Reader)new StringReader(jsonNode.toString())).readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toolsCall(JsonObject message, final Responder responder, McpConnection connection) {
        McpFeatureMetadata metadata;
        final String id = ((JsonValue)message.get((Object)"id")).toString();
        JsonObject params = ((JsonValue)message.get((Object)"params")).asJsonObject();
        final String toolName = params.getString("name");
        MCPLogger.ROOT_LOGGER.debugf("Call tool %s [id: %s]", (Object)toolName, (Object)id);
        final HashMap<String, JsonValue> args = new HashMap<String, JsonValue>();
        JsonObject arguments = params.getJsonObject("arguments");
        if (arguments != null) {
            for (String key : arguments.keySet()) {
                args.put(key, (JsonValue)arguments.get((Object)key));
            }
        }
        if ((metadata = this.registry.getTool(toolName)) == null) {
            responder.sendError(id, -32602, "Invalid tool name: " + toolName);
            return;
        }
        ClassLoader prevCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            connection.task(this.executorService.submit(new Runnable(){
                final /* synthetic */ ToolMessageHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Object result;
                        block20: {
                            MethodMetadata methodMetadata = metadata.method();
                            Class<?> clazz = this.this$0.classLoader.loadClass(methodMetadata.declaringClassName());
                            Instance beanInstance = CDI.current().select(clazz, new Annotation[]{McpTool.McpToolLiteral.INSTANCE});
                            result = null;
                            if (beanInstance.isResolvable()) {
                                MCPLogger.ROOT_LOGGER.debug((Object)("We have found the Singleton instance of the tool" + toolName));
                                try {
                                    if (args.isEmpty()) {
                                        result = this.this$0.registry.getToolInvoker(toolName).invoke(beanInstance.get());
                                        break block20;
                                    }
                                    ArrayList<Object> preparedArguments = new ArrayList<Object>(Arrays.asList(ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper)));
                                    preparedArguments.add(0, beanInstance.get());
                                    result = this.this$0.registry.getToolInvoker(toolName).invokeWithArguments(preparedArguments);
                                }
                                catch (Throwable ex) {
                                    MCPLogger.ROOT_LOGGER.error((Object)("Error invoking tool " + toolName), ex);
                                    responder.sendError(id, -32603, ex.getMessage());
                                }
                            } else {
                                MCPLogger.ROOT_LOGGER.warn((Object)("We have NOT found the Singleton instance of the tool" + toolName));
                                Method method = clazz.getMethod(methodMetadata.name(), methodMetadata.argumentTypes());
                                if (Modifier.isStatic(method.getModifiers())) {
                                    result = method.invoke(null, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                } else {
                                    Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
                                    Object instance = defaultConstructor.newInstance(new Object[0]);
                                    result = method.invoke(instance, ToolMessageHandler.prepareArguments(metadata, args, this.this$0.mapper));
                                }
                            }
                        }
                        Collection content = ContentMapper.processResultAsText((Object)result);
                        try (StringWriter out = new StringWriter();){
                            this.this$0.mapper.writeValue((Writer)out, (Object)content);
                            try (StringReader in = new StringReader(out.toString());){
                                JsonObjectBuilder builder = Json.createObjectBuilder();
                                builder.add("content", (JsonValue)Json.createReader((Reader)in).readArray());
                                responder.sendResult(id, builder);
                            }
                        }
                    }
                    catch (McpException e) {
                        MCPLogger.ROOT_LOGGER.error((Object)e);
                        responder.sendError(id, e.getJsonRpcError(), e.getMessage());
                    }
                    catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        MCPLogger.ROOT_LOGGER.error((Object)("Error invoking tool " + toolName), (Throwable)ex);
                        responder.sendError(id, -32603, ex.getMessage());
                    }
                }
            }));
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)prevCL);
        }
    }

    protected static Object[] prepareArguments(McpFeatureMetadata metadata, Map<String, JsonValue> args, ObjectMapper mapper) throws McpException {
        if (metadata.arguments().isEmpty()) {
            return new Object[0];
        }
        Object[] ret = new Object[metadata.arguments().size()];
        int idx = 0;
        for (ArgumentMetadata arg : metadata.arguments()) {
            JsonValue val = args.get(arg.name());
            if (val == null && arg.required()) {
                throw new McpException("Missing required argument: " + arg.name(), -32602);
            }
            if (val == null) {
                ret[idx] = null;
            } else if (val.getValueType() == JsonValue.ValueType.OBJECT) {
                javaType = mapper.getTypeFactory().constructType((Type)arg.type());
                try {
                    ret[idx] = mapper.readValue(val.toString(), javaType);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(e);
                }
            } else if (val.getValueType() == JsonValue.ValueType.ARRAY) {
                javaType = mapper.getTypeFactory().constructType((Type)arg.type());
                try {
                    ret[idx] = mapper.readValue(val.toString(), javaType);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(e);
                }
            } else if (arg.type() instanceof Class) {
                Class clazz = arg.type();
                if (clazz.isEnum()) {
                    ret[idx] = Enum.valueOf(clazz, val.toString());
                } else {
                    try {
                        ret[idx] = mapper.readValue(val.toString(), clazz);
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalStateException(e);
                    }
                }
            } else if (arg.type().isPrimitive()) {
                if (val.getValueType() == JsonValue.ValueType.NUMBER) {
                    if (Integer.TYPE.equals(arg.type())) {
                        ret[idx] = Integer.valueOf(val.toString());
                    } else if (Float.TYPE.equals(arg.type())) {
                        ret[idx] = Float.valueOf(val.toString());
                    } else if (Double.TYPE.equals(arg.type())) {
                        ret[idx] = Double.valueOf(val.toString());
                    } else if (Long.TYPE.equals(arg.type())) {
                        ret[idx] = Long.valueOf(val.toString());
                    } else if (Character.TYPE.equals(arg.type())) {
                        ret[idx] = Character.valueOf(val.toString().charAt(0));
                    }
                }
            } else {
                ret[idx] = val.toString();
            }
            ++idx;
        }
        return ret;
    }
}

