/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm.injection;

import com.dylibso.chicory.log.Logger;
import org.jboss.logging.Logger;
import org.wildfly.extension.wasm.injection.WASMLogger;

public class ChicoryLogger
implements Logger {
    static final ChicoryLogger ROOT_LOGGER = new ChicoryLogger();

    public void log(Logger.Level level, String msg, Throwable throwable) {
        if (Logger.Level.OFF == level) {
            return;
        }
        if (Logger.Level.ALL == level) {
            WASMLogger.ROOT_LOGGER.debug(msg, throwable);
        } else {
            WASMLogger.ROOT_LOGGER.log(this.getLevel(level), msg, throwable);
        }
    }

    public boolean isLoggable(Logger.Level level) {
        Logger.Level realLevel;
        if (Logger.Level.OFF == level) {
            return false;
        }
        switch (level) {
            case ALL: {
                return true;
            }
            case DEBUG: {
                realLevel = Logger.Level.DEBUG;
                break;
            }
            case ERROR: {
                realLevel = Logger.Level.ERROR;
                break;
            }
            case INFO: {
                realLevel = Logger.Level.INFO;
                break;
            }
            case OFF: {
                return false;
            }
            case TRACE: {
                realLevel = Logger.Level.TRACE;
                break;
            }
            case WARNING: {
                realLevel = Logger.Level.WARN;
                break;
            }
            default: {
                realLevel = Logger.Level.INFO;
            }
        }
        return WASMLogger.ROOT_LOGGER.isEnabled(realLevel);
    }

    private Logger.Level getLevel(Logger.Level level) {
        return switch (level) {
            case Logger.Level.ALL -> Logger.Level.TRACE;
            case Logger.Level.DEBUG -> Logger.Level.DEBUG;
            case Logger.Level.ERROR -> Logger.Level.ERROR;
            case Logger.Level.INFO -> Logger.Level.INFO;
            case Logger.Level.OFF -> Logger.Level.ERROR;
            case Logger.Level.TRACE -> Logger.Level.TRACE;
            case Logger.Level.WARNING -> Logger.Level.WARN;
            default -> Logger.Level.INFO;
        };
    }
}

