/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm.injection;

import com.dylibso.chicory.log.Logger;
import java.nio.file.Path;
import java.util.Map;
import org.extism.sdk.chicory.Manifest;
import org.extism.sdk.chicory.ManifestWasm;
import org.extism.sdk.chicory.Plugin;
import org.wildfly.extension.wasm.injection.ChicoryLogger;
import org.wildfly.wasm.api.WasmInvoker;

public class WasmToolConfiguration {
    private final String name;
    private final Path wasmFile;
    private final String[] allowedHosts;
    private final Integer minMemoryConstraints;
    private final Integer maxMemoryConstraint;
    private final boolean aot;
    private final Map<String, String> config;

    public WasmToolConfiguration(String name, Path wasmFile, String[] allowedHosts, Integer minMemoryConstraints, Integer maxMemoryConstraint, boolean aot, Map<String, String> config) {
        this.name = name;
        this.wasmFile = wasmFile;
        this.config = config;
        this.allowedHosts = allowedHosts;
        this.aot = aot;
        this.minMemoryConstraints = minMemoryConstraints;
        this.maxMemoryConstraint = maxMemoryConstraint;
    }

    public String name() {
        return this.name;
    }

    public WasmInvoker create() {
        ManifestWasm wasm = ManifestWasm.fromFilePath((Path)this.wasmFile).build();
        Manifest.Options options = new Manifest.Options().withAllowedHosts(this.allowedHosts).withAoT(this.aot).withConfig(this.config);
        if (this.minMemoryConstraints != null && this.maxMemoryConstraint != null) {
            options = options.withMemoryLimits(this.minMemoryConstraints.intValue(), this.maxMemoryConstraint.intValue());
        }
        Manifest manifest = Manifest.ofWasms((ManifestWasm[])new ManifestWasm[]{wasm}).withOptions(options).build();
        final Plugin plugin = Plugin.ofManifest((Manifest)manifest).withLogger((Logger)ChicoryLogger.ROOT_LOGGER).build();
        return new WasmInvoker(){
            final /* synthetic */ WasmToolConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public byte[] call(String method, byte[] input) {
                return plugin.call(method, input);
            }
        };
    }
}

