/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm.deployment;

import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.wasm.WasmLogger;
import org.wildfly.extension.wasm.deployment.WasmAttachements;
import org.wildfly.extension.wasm.injection.WasmPortableExtension;
import org.wildfly.extension.wasm.injection.WasmServicePortableExtension;
import org.wildfly.extension.wasm.injection.WildFlyWasmRegistry;

public class WasmCDIProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        WildFlyWasmRegistry wasmRegistry = new WildFlyWasmRegistry();
        deploymentUnit.getAttachmentList(WasmAttachements.WASM_TOOL_CONFIGURATIONS).forEach(c -> wasmRegistry.registerWasmTool(c));
        Optional weldCapability = support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        if (weldCapability != null && weldCapability.isPresent() && !((WeldCapability)weldCapability.get()).isPartOfWeldDeployment(deploymentUnit)) {
            WasmLogger.ROOT_LOGGER.cdiRequired();
        } else {
            ((WeldCapability)weldCapability.get()).registerExtensionInstance((Extension)new WasmPortableExtension(wasmRegistry), deploymentUnit);
            if (support.hasCapability("org.wildfly.ai.mcp.server")) {
                try {
                    Annotation mcpToolQualifier = (Annotation)Annotation.class.cast(Class.forName("org.wildfly.extension.mcp.injection.tool.McpTool$McpToolLiteral").getDeclaredField("INSTANCE").get(null));
                    ((WeldCapability)weldCapability.get()).registerExtensionInstance((Extension)new WasmServicePortableExtension(new Annotation[]{mcpToolQualifier}), deploymentUnit);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    WasmLogger.ROOT_LOGGER.error(ex);
                    ((WeldCapability)weldCapability.get()).registerExtensionInstance((Extension)new WasmServicePortableExtension(new Annotation[0]), deploymentUnit);
                }
            } else {
                ((WeldCapability)weldCapability.get()).registerExtensionInstance((Extension)new WasmServicePortableExtension(new Annotation[0]), deploymentUnit);
            }
        }
        try {
            DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
            deploymentUnit.getAttachmentList(WasmAttachements.WASM_TOOL_CONFIGURATIONS).forEach(c -> deploymentResourceSupport.getDeploymentSubModel("wasm", PathElement.pathElement((String)"module", (String)c.name())));
        }
        catch (Exception e) {
            WasmLogger.ROOT_LOGGER.error(e);
        }
    }
}

