/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm.deployment;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.wasm.Capabilities;
import org.wildfly.extension.wasm.WasmLogger;
import org.wildfly.extension.wasm.deployment.WasmAttachements;
import org.wildfly.wasm.api.WasmTool;
import org.wildfly.wasm.api.WasmToolService;

public class WasmDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"jakarta.json.api").setOptional(false).setImportServices(true).build());
        ModuleDependency modDep = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.wildfly.extension.wasm.injection").setOptional(false).setExport(true).setImportServices(true).build();
        modDep.addImportFilter(s -> s.equals("META-INF"), true);
        moduleSpecification.addSystemDependency(modDep);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            throw WasmLogger.ROOT_LOGGER.unableToResolveAnnotationIndex(deploymentUnit);
        }
        List annotations = index.getAnnotations(DotName.createSimple(WasmTool.class));
        this.processWasmTools(deploymentPhaseContext, annotations);
        annotations = index.getAnnotations(DotName.createSimple(WasmToolService.class));
        this.processWasmToolServices(deploymentPhaseContext, annotations);
    }

    private void processWasmTools(DeploymentPhaseContext deploymentPhaseContext, List<AnnotationInstance> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        for (AnnotationInstance annotation : annotations) {
            String name = annotation.value("name") != null ? annotation.value("name").asString() : (annotation.target().kind() == AnnotationTarget.Kind.FIELD ? annotation.target().asField().name() : annotation.target().asMethodParameter().name());
            deploymentUnit.addToAttachmentList(WasmAttachements.WASM_TOOL_NAMES, (Object)name);
            deploymentPhaseContext.addDeploymentDependency(Capabilities.WASM_TOOL_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{name}), WasmAttachements.WASM_TOOL_CONFIGURATIONS);
        }
    }

    private void processWasmToolServices(DeploymentPhaseContext deploymentPhaseContext, List<AnnotationInstance> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        for (AnnotationInstance annotation : annotations) {
            if (annotation.value("wasmToolConfigurationName") == null) continue;
            String name = annotation.value("wasmToolConfigurationName").asString();
            deploymentUnit.addToAttachmentList(WasmAttachements.WASM_TOOL_NAMES, (Object)name);
            deploymentPhaseContext.addDeploymentDependency(Capabilities.WASM_TOOL_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{name}), WasmAttachements.WASM_TOOL_CONFIGURATIONS);
        }
    }
}

