/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.wasm.Capabilities;
import org.wildfly.extension.wasm.WasmProviderServiceConfigurator;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class WasmProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    protected static final SimpleAttributeDefinition WASM_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).setXmlName("path")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition WASM_RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setXmlName("relative-to")).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setCapabilityReference(PathManager.PATH_SERVICE_DESCRIPTOR.getName())).build();
    protected static final SimpleAttributeDefinition WASM_AOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-aot", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition WASM_MEMORY_CONSTRAINTS_MINIMAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-memory-contraint", ModelType.INT, true).setAllowExpression(true)).setValidator(IntRangeValidator.POSITIVE)).build();
    protected static final SimpleAttributeDefinition WASM_MEMORY_CONSTRAINTS_MAXIMAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-memory-contraint", ModelType.INT, true).setAllowExpression(true)).setValidator(IntRangeValidator.POSITIVE)).build();
    protected static final StringListAttributeDefinition WASM_ALLOWED_HOSTS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("allowed-hosts").setAllowExpression(true)).setRequired(false)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(WASM_ALLOWED_HOSTS, WASM_AOT, WASM_MEMORY_CONSTRAINTS_MINIMAL, WASM_MEMORY_CONSTRAINTS_MAXIMAL, WASM_PATH, WASM_RELATIVE_TO);
    static final String WASM_TOOL = "wasm-tool";
    private final ResourceDescriptor descriptor;
    public static final PathElement PATH = PathElement.pathElement((String)"wasm-tool");
    public static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PATH);

    public WasmProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.WASM_TOOL_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new WasmProviderServiceConfigurator()))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext mrrc) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

