/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.event.impl.internal.Notification;

public class HibernateSecondLevelCache {
    private static final String DEFAULT_REGION_FACTORY = "org.infinispan.hibernate.cache.v62.InfinispanRegionFactory";
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String NAME = "name";
    public static final String CACHES = "caches";

    public static void addSecondLevelCacheDependencies(Properties mutableProperties, String scopedPersistenceUnitName) {
        String regionFactory;
        if (mutableProperties.getProperty("hibernate.cache.region_prefix") == null && scopedPersistenceUnitName != null) {
            mutableProperties.setProperty("hibernate.cache.region_prefix", scopedPersistenceUnitName);
        }
        if ((regionFactory = mutableProperties.getProperty("hibernate.cache.region.factory_class")) == null) {
            regionFactory = DEFAULT_REGION_FACTORY;
            mutableProperties.setProperty("hibernate.cache.region.factory_class", regionFactory);
        }
        if (Boolean.parseBoolean(mutableProperties.getProperty("hibernate.cache.infinispan.shared", "true"))) {
            String container = mutableProperties.getProperty("hibernate.cache.infinispan.container");
            if (container == null) {
                container = "hibernate";
                mutableProperties.setProperty("hibernate.cache.infinispan.container", container);
            }
            Properties cacheSettings = new Properties();
            cacheSettings.setProperty(CONTAINER, container);
            cacheSettings.setProperty(CACHES, String.join((CharSequence)" ", HibernateSecondLevelCache.findCaches(mutableProperties)));
            Notification.addCacheDependencies((Classification)Classification.INFINISPAN, (Properties)cacheSettings);
        }
    }

    public static Set<String> findCaches(Properties properties) {
        HashSet<String> caches = new HashSet<String>();
        caches.add(properties.getProperty("hibernate.cache.infinispan.entity.cfg", "entity"));
        caches.add(properties.getProperty("hibernate.cache.infinispan.immutable-entity.cfg", "entity"));
        caches.add(properties.getProperty("hibernate.cache.infinispan.collection.cfg", "entity"));
        caches.add(properties.getProperty("hibernate.cache.infinispan.naturalid.cfg", "entity"));
        caches.add(properties.getProperty("hibernate.cache.infinispan.pending-puts.cfg", "pending-puts"));
        if (Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_query_cache"))) {
            caches.add(properties.getProperty("hibernate.cache.infinispan.query.cfg", "local-query"));
            caches.add(properties.getProperty("hibernate.cache.infinispan.timestamps.cfg", "timestamps"));
        }
        int length = "hibernate.cache.infinispan.cfg".length();
        String customRegionPrefix = "hibernate.cache.infinispan.cfg".substring(0, length - 3) + properties.getProperty("hibernate.cache.region_prefix", "");
        String customRegionSuffix = "hibernate.cache.infinispan.cfg".substring(length - 4, length);
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(customRegionPrefix) || !propertyName.endsWith(customRegionSuffix)) continue;
            caches.add(properties.getProperty(propertyName));
        }
        return caches;
    }
}

