/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mail.ra;

import java.util.concurrent.ConcurrentHashMap;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.wildfly.mail.ra.MailActivation;
import org.wildfly.mail.ra.MailActivationSpec;
import org.wildfly.mail.ra.NewMsgsWorker;

@Connector(displayName={"JavaMail Adapter"}, description={"WildFly JavaMail Resource Adapter"}, vendorName="Red Hat, Inc.", eisType="JavaMail Adapter", licenseRequired=true, licenseDescription={"JBoss, Home of Professional Open Source.\nCopyright 2014, Red Hat, Inc., and individual contributors\nas indicated by the @author tags. See the copyright.txt file in the\ndistribution for a full listing of individual contributors.\n\nThis is free software; you can redistribute it and/or modify it\nunder the terms of the GNU Lesser General Public License as\npublished by the Free Software Foundation; either version 2.1 of\nthe License, or (at your option) any later version.\n\nThis software is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\nLesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public\nLicense along with this software; if not, write to the Free\nSoftware Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA\n02110-1301 USA, or see the FSF site: http://www.fsf.org.\n"})
public class MailResourceAdapter
implements ResourceAdapter {
    private static Logger log = Logger.getLogger(MailResourceAdapter.class);
    private BootstrapContext ctx = null;
    private ConcurrentHashMap<MailActivationSpec, MailActivation> activations = new ConcurrentHashMap();
    private NewMsgsWorker newMsgsWorker = null;
    private Integer queueSize = 1024;

    public Integer getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(Integer v) {
        if (v != null && v > 0) {
            this.queueSize = v;
        }
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        log.debugf("start", new Object[0]);
        this.ctx = ctx;
        WorkManager mgr = ctx.getWorkManager();
        this.newMsgsWorker = new NewMsgsWorker(mgr, this.queueSize);
        try {
            mgr.scheduleWork((Work)this.newMsgsWorker);
        }
        catch (WorkException e) {
            throw new ResourceAdapterInternalException((Throwable)e);
        }
    }

    public void stop() {
        log.debugf("stop", new Object[0]);
        this.newMsgsWorker.release();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        log.debugf("endpointActivation: endpointFactory=%s,spec=%s", (Object)endpointFactory, (Object)spec);
        if (spec == null) {
            throw new NotSupportedException("Null MailActivationSpec instance");
        }
        if (!(spec instanceof MailActivationSpec)) {
            throw new NotSupportedException("Not a MailActivationSpec instance" + spec.getClass().getName());
        }
        MailActivationSpec mailSpec = (MailActivationSpec)spec;
        MailActivation activation = new MailActivation(endpointFactory, mailSpec);
        try {
            this.newMsgsWorker.watch(activation);
            this.activations.put(mailSpec, activation);
        }
        catch (InterruptedException e) {
            throw new ResourceException("Failed to schedule new msg check", (Throwable)e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        MailActivation activation;
        log.debugf("endpointDeactivation: endpointFactory=%s,spec=%s", (Object)endpointFactory, (Object)spec);
        if (spec != null && spec instanceof MailActivationSpec && (activation = this.activations.remove(spec)) != null) {
            activation.release();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }
}

