/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mail.ra;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.wildfly.mail.ra.MailActivationSpec;
import org.wildfly.mail.ra.MailFolder;

public class IMAPMailFolder
extends MailFolder {
    public IMAPMailFolder(MailActivationSpec spec) {
        super(spec);
    }

    @Override
    protected Message[] getMessages(Folder folder) throws MessagingException {
        Message[] result = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
        if (result != null && result.length > 0) {
            return result;
        }
        return new Message[0];
    }

    @Override
    protected Store openStore(Session session) throws NoSuchProviderException {
        return session.getStore("imap");
    }

    @Override
    protected void markMessageSeen(Message message) throws MessagingException {
        message.setFlag(Flags.Flag.SEEN, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeStore(boolean success, Store store, Folder folder) throws MessagingException {
        try {
            if (folder != null && folder.isOpen()) {
                folder.close(success);
            }
        }
        finally {
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
    }
}

