/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mail.ra;

import java.util.concurrent.PriorityBlockingQueue;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.jboss.logging.Logger;
import org.wildfly.mail.ra.MailActivation;

public class NewMsgsWorker
implements Work,
WorkListener {
    private static Logger log = Logger.getLogger(NewMsgsWorker.class);
    private boolean released;
    private WorkManager mgr;
    private PriorityBlockingQueue<MailActivation> pollQueue;

    public NewMsgsWorker(WorkManager mgr, Integer queueSize) {
        this.mgr = mgr;
        this.pollQueue = new PriorityBlockingQueue(queueSize);
    }

    public void watch(MailActivation activation) throws InterruptedException {
        activation.updateNextNewMsgCheckTime(System.currentTimeMillis());
        this.pollQueue.put(activation);
    }

    public void release() {
        this.released = true;
        log.tracef("released", new Object[0]);
    }

    public void run() {
        log.tracef("Begin run", new Object[0]);
        while (!this.released) {
            try {
                MailActivation ma = this.pollQueue.take();
                long now = System.currentTimeMillis();
                long nextTime = ma.getNextNewMsgCheckTime();
                long sleepMS = nextTime - now;
                if (sleepMS > 0L) {
                    Thread.sleep(sleepMS);
                }
                if (this.released) break;
                if (ma.isReleased()) continue;
                this.mgr.scheduleWork((Work)ma, Long.MAX_VALUE, null, (WorkListener)this);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted waiting for new msg check. NewMsgsWorker will stop checking for new messages.");
                Thread.currentThread().interrupt();
            }
            catch (WorkException e) {
                log.warn((Object)"Failed to schedule new msg check", (Throwable)e);
            }
        }
        log.tracef("End run", new Object[0]);
    }

    public void workAccepted(WorkEvent e) {
        log.tracef("workAccepted: e=%s", (Object)e);
    }

    public void workRejected(WorkEvent e) {
        log.tracef("workRejected: e=%s", (Object)e);
    }

    public void workStarted(WorkEvent e) {
        log.tracef("workStarted: e=%s", (Object)e);
    }

    public void workCompleted(WorkEvent e) {
        log.tracef("workCompleted: e=%s", (Object)e);
        MailActivation activation = (MailActivation)e.getWork();
        try {
            activation.unrelease();
            this.watch(activation);
        }
        catch (InterruptedException ex) {
            log.warn((Object)"Failed to reschedule new msg check", (Throwable)ex);
        }
    }
}

