/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public class Environment
implements AutoCloseable {
    static final String SERVER_CONFIG_FILE_NAME = "server-config.xml";
    static final String SERVER_INIT_CLI_FILE_NAME = "server-init.cli";
    static final String SERVER_INIT_YML_FILE_NAME = "server-init.yml";
    static final String SERVER_INIT_YML_SERVICE_LOADER_NAME = "org.jboss.as.controller.persistence.ConfigurationExtension";
    static final String SERVER_INIT_YML_SERVICE_LOADER_CONTENTS = "org.jboss.as.controller.persistence.yaml.YamlConfigurationExtension";
    static final String DATA_SOURCES_FEATURE_PACK_LOCATION_PROPERTY = "${datasources.feature.pack.location}";
    private static final Entry WAR_LOCATION = new Entry(true, "wildfly.builder.war.location", "WILDFLY_BUILDER_WAR_LOCATION");
    private static final Entry SERVER_IMAGE_BUILDER_LOCATION = new Entry(true, "wildfly.builder.server.image.builder.location", "WILDFLY_BUILDER_SERVER_IMAGE_BUILDER_LOCATION");
    private static final PropertyOverrideEntry[] propertyReplacementEntries = new PropertyOverrideEntry[]{new PropertyOverrideEntry("cloud.feature.pack.version", "CLOUD_FEATURE_PACK_VERSION"), new PropertyOverrideEntry("datasources.feature.pack.version", "DATASOURCES_FEATURE_PACK_VERSION"), new PropertyOverrideEntry("server.feature-pack.location", "SERVER_FEATURE_PACK_LOCATION"), new PropertyOverrideEntry("server.runtime.base.image", "SERVER_RUNTIME_BASE_IMAGE")};
    private final InputStream warInputStream;
    private final Path serverImageBuilderLocation;
    private final Path serverImageDeploymentLocation;
    private final Path inputPomLocation;
    private final Path createdPomLocation;
    private final Path serverConfigXmlPath;
    private final Path serverInitCliPath;
    private final Path serverInitYmlPath;
    private final Path serverInitYmlServiceLoaderPath;
    private final Set<String> datasourceGalleonPackLayers;
    private final Map<String, String> mavenPropertyOverrides;

    private Environment(InputStream warInputStream, Path serverImageBuilderLocation, Set<String> datasourceGalleonPackLayers, Map<String, String> mavenPropertyOverrides) throws IOException {
        this.warInputStream = warInputStream;
        this.serverImageBuilderLocation = serverImageBuilderLocation;
        this.inputPomLocation = serverImageBuilderLocation.resolve("input-pom.xml");
        this.createdPomLocation = serverImageBuilderLocation.resolve("pom.xml");
        this.datasourceGalleonPackLayers = datasourceGalleonPackLayers;
        this.mavenPropertyOverrides = mavenPropertyOverrides;
        Path serverBuilderFilesLocation = serverImageBuilderLocation.resolve("files");
        if (!Files.exists(serverBuilderFilesLocation, new LinkOption[0])) {
            Files.createDirectories(serverBuilderFilesLocation, new FileAttribute[0]);
        }
        this.serverImageDeploymentLocation = serverBuilderFilesLocation.resolve("ROOT.war");
        this.serverConfigXmlPath = serverBuilderFilesLocation.resolve(SERVER_CONFIG_FILE_NAME);
        this.serverInitCliPath = serverBuilderFilesLocation.resolve(SERVER_INIT_CLI_FILE_NAME);
        this.serverInitYmlPath = serverBuilderFilesLocation.resolve(SERVER_INIT_YML_FILE_NAME);
        this.serverInitYmlServiceLoaderPath = serverBuilderFilesLocation.resolve(SERVER_INIT_YML_SERVICE_LOADER_NAME);
        URL inputPomUrl = Environment.class.getResource("/input-pom.xml");
        if (inputPomUrl == null) {
            throw new IllegalStateException("Could not find the bundled input-pom.xml");
        }
        try (BufferedInputStream in = new BufferedInputStream(inputPomUrl.openStream());
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.inputPomLocation.toFile()));){
            byte[] buf = new byte[8092];
            int len = ((InputStream)in).read(buf);
            while (len != -1) {
                ((OutputStream)out).write(buf, 0, len);
                len = ((InputStream)in).read(buf);
            }
        }
    }

    public InputStream getWarInputStream() {
        return this.warInputStream;
    }

    public Path getServerImageDeploymentLocation() {
        return this.serverImageDeploymentLocation;
    }

    public Path getInputPomLocation() {
        return this.inputPomLocation;
    }

    public Path getCreatedPomLocation() {
        return this.createdPomLocation;
    }

    public Path getServerConfigXmlPath() {
        return this.serverConfigXmlPath;
    }

    public Path getServerInitCliPath() {
        return this.serverInitCliPath;
    }

    public Path getServerInitYmlPath() {
        return this.serverInitYmlPath;
    }

    public Path getServerInitYmlServiceLoaderPath() {
        return this.serverInitYmlServiceLoaderPath;
    }

    public Set<String> getDatasourceGalleonPackLayers() {
        return this.datasourceGalleonPackLayers;
    }

    public Map<String, String> getMavenPropertyOverrides() {
        return this.mavenPropertyOverrides;
    }

    @Override
    public void close() throws Exception {
        Environment.safeClose(this.warInputStream);
    }

    static String getToolVersion() throws IOException {
        return Environment.readManifestValue("tool-version");
    }

    static String readManifestValue(String name) throws IOException {
        Enumeration<URL> e = Environment.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            InputStream stream = url.openStream();
            try {
                String value;
                Manifest manifest = null;
                if (stream == null || (value = (manifest = new Manifest(stream)).getMainAttributes().getValue(name)) == null) continue;
                String string = value;
                return string;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        throw new IllegalStateException("Could not find manifest entry: " + name);
    }

    static Environment initialize() {
        InputStream warInputStream = null;
        try {
            warInputStream = Environment.getLocalOrRemoteInputStream(WAR_LOCATION.read());
            Path serverImageBuilderLocation = Paths.get(SERVER_IMAGE_BUILDER_LOCATION.read(), new String[0]);
            if (!Files.exists(serverImageBuilderLocation, new LinkOption[0])) {
                throw new IllegalStateException("Cannot find " + serverImageBuilderLocation);
            }
            HashMap<String, String> mavenPropertyOverrides = new HashMap<String, String>();
            for (PropertyOverrideEntry entry : propertyReplacementEntries) {
                String override = entry.getOverride();
                if (override == null) continue;
                mavenPropertyOverrides.put(entry.property, override);
            }
            Set<String> datasourceGalleonPackLayers = Environment.populateDatasourceGalleonPackLayers();
            return new Environment(warInputStream, serverImageBuilderLocation, datasourceGalleonPackLayers, mavenPropertyOverrides);
        }
        catch (Throwable t) {
            Environment.safeClose(warInputStream);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static Set<String> populateDatasourceGalleonPackLayers() throws IOException, URISyntaxException {
        URL url = Environment.class.getResource("/datasource-layers.txt");
        if (url == null) {
            throw new IllegalStateException("Missing datasource-layers.txt");
        }
        LinkedList<String> lines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        HashSet<String> layers = new HashSet<String>();
        for (String line : lines) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            layers.add(line);
        }
        return layers;
    }

    private static InputStream getLocalOrRemoteInputStream(String location) throws IOException {
        try {
            URL url = new URL(location);
            return new BufferedInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            Path path = Path.of(location, new String[0]);
            if (!path.isAbsolute()) {
                path = Path.of(".", new String[0]).resolve(path).normalize();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException(location + " resolves to the follwing non-existant location: " + path);
            }
            return new BufferedInputStream(new FileInputStream(path.toFile()));
        }
    }

    private static void safeClose(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class PropertyOverrideEntry
    extends Entry {
        public PropertyOverrideEntry(String property, String envVar) {
            super(false, property, envVar);
        }

        String getOverride() {
            return super.read();
        }
    }

    private static class Entry {
        private final boolean required;
        protected final String property;
        private final String envVar;

        public Entry(boolean required, String property, String envVar) {
            this.required = required;
            this.property = property;
            this.envVar = envVar;
        }

        String read() {
            String value = System.getProperty(this.property);
            if (value != null) {
                return value.trim();
            }
            value = System.getenv(this.envVar);
            if (value != null) {
                return value.trim();
            }
            if (this.required) {
                String msg = String.format("Neither system property %s, nor environment variable %s was set", this.property, this.envVar);
                throw new IllegalStateException(msg);
            }
            return null;
        }
    }
}

