/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.managed.server.builder.tool.Environment;
import org.wildfly.managed.server.builder.tool.parser.FormattingXMLStreamWriter;
import org.wildfly.managed.server.builder.tool.parser.Node;
import org.wildfly.managed.server.builder.tool.parser.generic.ElementNode;
import org.wildfly.managed.server.builder.tool.parser.generic.PomParser;
import org.wildfly.managed.server.builder.tool.parser.generic.ProcessingInstructionNode;
import org.wildfly.managed.server.builder.tool.parser.generic.TextNode;
import org.wildfly.managed.server.builder.tool.parser.serverconfig.ServerConfig;
import org.wildfly.managed.server.builder.tool.parser.serverconfig.ServerConfigParser;

public class Tool {
    private final Environment environment;

    public Tool(Environment environment) {
        this.environment = environment;
    }

    void prepareDeployment() throws Exception {
        this.copyDeploymentToServerImageBuilder();
        this.getServerConfigXmlContentsFromDeployment();
        this.mergeInputPomAndServerConfigXml();
    }

    private void copyDeploymentToServerImageBuilder() throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.environment.getServerImageDeploymentLocation().toFile()));){
            InputStream in = this.environment.getWarInputStream();
            byte[] bytes = new byte[8192];
            int len = in.read(bytes);
            while (len != -1) {
                ((OutputStream)out).write(bytes, 0, len);
                len = in.read(bytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerConfigXmlContentsFromDeployment() throws IOException {
        boolean foundServerConfigXml = false;
        boolean foundServerInitCli = false;
        boolean foundServerInitYml = false;
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.environment.getServerImageDeploymentLocation().toFile())));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                try {
                    if (this.isMetaInfFile(entry.getName(), "server-config.xml")) {
                        if (foundServerConfigXml) {
                            throw new IllegalStateException("The archive contains duplicate server-config.xml files");
                        }
                        foundServerConfigXml = true;
                        this.extractCurrentFile(zin, this.environment.getServerConfigXmlPath());
                        continue;
                    }
                    if (this.isMetaInfFile(entry.getName(), "server-init.cli")) {
                        if (foundServerInitCli) {
                            throw new IllegalStateException("The archive contains duplicate server-init.cli files");
                        }
                        foundServerInitCli = true;
                        this.extractCurrentFile(zin, this.environment.getServerInitCliPath());
                        continue;
                    }
                    if (!this.isMetaInfFile(entry.getName(), "server-init.yml")) continue;
                    if (foundServerInitYml) {
                        throw new IllegalStateException("The archive contains duplicate server-init.yml files");
                    }
                    foundServerInitYml = true;
                    this.extractCurrentFile(zin, this.environment.getServerInitYmlPath());
                }
                finally {
                    zin.closeEntry();
                    entry = zin.getNextEntry();
                }
            }
        }
        if (!foundServerConfigXml) {
            throw new IllegalStateException("The deployment does not contain a server-config.xml file");
        }
    }

    private boolean isMetaInfFile(String jarEntryName, String filename) {
        if (jarEntryName.endsWith(filename)) {
            return jarEntryName.equals("WEB-INF/classes/META-INF/" + filename) || jarEntryName.equals("META-INF/" + filename);
        }
        return false;
    }

    private void extractCurrentFile(ZipInputStream zin, Path path) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path.toFile()));){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = zin.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeInputPomAndServerConfigXml() throws XMLStreamException, IOException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        LinkedList<String> commandLineArguments = new LinkedList<String>();
        ServerConfigParser serverConfigXmlParser = new ServerConfigParser(this.environment.getServerConfigXmlPath());
        ServerConfig serverConfig = serverConfigXmlParser.parse();
        PomParser pomParser = new PomParser(this.environment.getInputPomLocation());
        pomParser.parse();
        ProcessingInstructionNode mavenPluginLayersPlaceholder = pomParser.getMavenPluginLayersPlaceholder();
        mavenPluginLayersPlaceholder.addDelegate(serverConfig.getLayers(), true);
        for (String string : serverConfig.getLayers().getLayers()) {
            if (!this.environment.getDatasourceGalleonPackLayers().contains(string)) continue;
            ProcessingInstructionNode datasourcesFeaturePackPlaceholder = pomParser.getDatasourcesFeaturePackPlaceholder();
            datasourcesFeaturePackPlaceholder.addDelegate(new Node(){

                @Override
                public void marshall(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeStartElement("feature-pack");
                    writer.writeStartElement("location");
                    writer.writeCharacters("${datasources.feature.pack.location}");
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            }, true);
            break;
        }
        if (this.environment.getMavenPropertyOverrides().size() > 0) {
            ProcessingInstructionNode mavenPropertyOverrides = pomParser.getPropertyOverridesPlaceholder();
            mavenPropertyOverrides.addDelegate(new Node(){

                @Override
                public void marshall(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeStartElement("properties");
                    for (Map.Entry<String, String> entry : Tool.this.environment.getMavenPropertyOverrides().entrySet()) {
                        writer.writeStartElement(entry.getKey());
                        writer.writeCharacters(entry.getValue());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }, true);
        }
        if (Files.exists(this.environment.getServerInitCliPath(), new LinkOption[0])) {
            environmentVariables.put("CLI_LAUNCH_SCRIPT", "standalone/configuration/init/server-init.cli");
        }
        if (Files.exists(this.environment.getServerInitYmlPath(), new LinkOption[0])) {
            Files.writeString(this.environment.getServerInitYmlServiceLoaderPath(), (CharSequence)"org.jboss.as.controller.persistence.yaml.YamlConfigurationExtension", new OpenOption[0]);
            commandLineArguments.add("--yaml init/server-init.yml");
        }
        if (commandLineArguments.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String arg : commandLineArguments) {
                sb.append(" ");
                sb.append(arg);
            }
            environmentVariables.put("SERVER_ARGS", sb.toString());
        }
        ProcessingInstructionNode dockerPluginEnvVarsPlaceholder = pomParser.getDockerPluginEnvVarsPlaceholder();
        for (Map.Entry entry : environmentVariables.entrySet()) {
            ElementNode node = new ElementNode(dockerPluginEnvVarsPlaceholder.getParent(), (String)entry.getKey());
            node.addChild(new TextNode((String)entry.getValue()));
            dockerPluginEnvVarsPlaceholder.addDelegate(node, true);
        }
        FormattingXMLStreamWriter formattingXMLStreamWriter = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedWriter(new FileWriter(this.environment.getCreatedPomLocation().toFile()))));
        try {
            formattingXMLStreamWriter.writeStartDocument();
            pomParser.getRootNode().marshall(formattingXMLStreamWriter);
            formattingXMLStreamWriter.writeEndDocument();
        }
        finally {
            try {
                formattingXMLStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

