/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool.parser.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.managed.server.builder.tool.parser.Node;
import org.wildfly.managed.server.builder.tool.parser.generic.AttributeValue;

public class ElementNode
implements Node {
    private final ElementNode parent;
    private final String name;
    private final String namespace;
    private final Map<String, AttributeValue> attributes = new LinkedHashMap<String, AttributeValue>();
    private List<Node> children = new ArrayList<Node>();

    public ElementNode(ElementNode parent, String name) {
        this(parent, name, parent.getNamespace());
    }

    ElementNode(ElementNode parent, String name, String namespace) {
        this.parent = parent;
        this.name = name;
        this.namespace = namespace == null ? namespace : (namespace.isEmpty() ? null : namespace);
    }

    public ElementNode updateForNewNsAndParent(ElementNode parent, String namespace) {
        ElementNode copy = new ElementNode(parent, this.name, namespace);
        copy.attributes.putAll(this.attributes);
        for (Node child : this.children) {
            if (child instanceof ElementNode) {
                copy.children.add(((ElementNode)child).updateForNewNsAndParent(copy, namespace));
                continue;
            }
            copy.children.add(child);
        }
        return copy;
    }

    public ElementNode getNamedChildElement(String name) {
        for (Node node : this.children) {
            if (!(node instanceof ElementNode)) continue;
            ElementNode en = (ElementNode)node;
            if (!name.equals(en.name)) continue;
            return en;
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public void addAttribute(String name, AttributeValue value) {
        this.attributes.put(name, value);
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public Collection<Node> getChildren() {
        return this.children;
    }

    public ElementNode getParent() {
        return this.parent;
    }

    public Iterator<Node> iterateChildren() {
        return this.children.iterator();
    }

    public String getAttributeValue(String name) {
        AttributeValue av = this.attributes.get(name);
        if (av == null) {
            return null;
        }
        return av.getValue();
    }

    public String getAttributeValue(String name, String defaultValue) {
        String s = this.getAttributeValue(name);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    @Override
    public void marshall(XMLStreamWriter writer) throws XMLStreamException {
        boolean empty = this.isEmpty();
        NamespaceContext context = writer.getNamespaceContext();
        String prefix = writer.getNamespaceContext().getPrefix(this.namespace);
        if (prefix == null) {
            writer.setDefaultNamespace(this.namespace);
            if (empty) {
                writer.writeEmptyElement(this.name);
            } else {
                writer.writeStartElement(this.name);
            }
            writer.writeNamespace(null, this.namespace);
        } else if (empty) {
            writer.writeEmptyElement(this.namespace, this.name);
        } else {
            writer.writeStartElement(this.namespace, this.name);
        }
        for (Map.Entry<String, AttributeValue> attr : this.attributes.entrySet()) {
            writer.writeAttribute(attr.getKey(), attr.getValue().getValue());
        }
        for (Node child : this.children) {
            child.marshall(writer);
        }
        if (!empty) {
            writer.writeEndElement();
        }
    }

    private boolean isEmpty() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (Node child : this.children) {
            if (!child.hasContent()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Element(name=" + this.name + ",ns=" + this.namespace + ")";
    }
}

