/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool.parser.generic;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.managed.server.builder.tool.parser.ParsingUtils;
import org.wildfly.managed.server.builder.tool.parser.generic.ElementNode;
import org.wildfly.managed.server.builder.tool.parser.generic.NodeParser;
import org.wildfly.managed.server.builder.tool.parser.generic.ProcessingInstructionNode;

public class PomParser
extends NodeParser {
    public static final String MAVEN_PLUGIN_LAYERS_PI = "MAVEN_PLUGIN_LAYERS";
    public static final String DOCKER_PLUGIN_ENV_VAR_PI = "DOCKER_PLUGIN_ENV_VARS";
    public static final String DATASOURCES_FEATURE_PACK_PI = "DATASOURCES_FEATURE_PACK";
    public static final String PROPERTY_OVERRIDES_PI = "PROPERTY_OVERRIDES";
    private static final String ROOT_ELEMENT_NAME = "project";
    private final Path inputFile;
    private ElementNode root;
    private ProcessingInstructionNode mavenPluginLayersPlaceholder;
    private ProcessingInstructionNode dockerPluginEnvVarsPlaceholder;
    private ProcessingInstructionNode datasourcesFeaturePackPlaceholder;
    private ProcessingInstructionNode propertyOverridesPlaceholder;

    public PomParser(Path inputFile) {
        this.inputFile = inputFile;
    }

    public ElementNode getRootNode() {
        return this.root;
    }

    public ProcessingInstructionNode getMavenPluginLayersPlaceholder() {
        return this.mavenPluginLayersPlaceholder;
    }

    public ProcessingInstructionNode getDockerPluginEnvVarsPlaceholder() {
        return this.dockerPluginEnvVarsPlaceholder;
    }

    public ProcessingInstructionNode getDatasourcesFeaturePackPlaceholder() {
        return this.datasourcesFeaturePackPlaceholder;
    }

    public ProcessingInstructionNode getPropertyOverridesPlaceholder() {
        return this.propertyOverridesPlaceholder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, XMLStreamException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.inputFile.toFile()));
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            reader.require(7, null, null);
            ParsingUtils.getNextElement(reader, ROOT_ELEMENT_NAME, null, false);
            this.root = super.parseNode(reader, ROOT_ELEMENT_NAME);
            this.validateAllProcessingInstructionsExist();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    private void validateAllProcessingInstructionsExist() {
        HashSet<String> missing = new HashSet<String>();
        if (this.mavenPluginLayersPlaceholder == null) {
            missing.add(this.toProcessingInstruction(MAVEN_PLUGIN_LAYERS_PI));
        }
        if (this.dockerPluginEnvVarsPlaceholder == null) {
            missing.add(this.toProcessingInstruction(DOCKER_PLUGIN_ENV_VAR_PI));
        }
        if (this.datasourcesFeaturePackPlaceholder == null) {
            missing.add(this.toProcessingInstruction(DATASOURCES_FEATURE_PACK_PI));
        }
        if (this.propertyOverridesPlaceholder == null) {
            missing.add(this.toProcessingInstruction(PROPERTY_OVERRIDES_PI));
        }
        if (missing.size() > 0) {
            throw new IllegalStateException("The input pom is missing the following processing instructions: " + missing);
        }
    }

    private String toProcessingInstruction(String name) {
        return "<?" + name + "?>";
    }

    @Override
    protected ProcessingInstructionNode parseProcessingInstruction(XMLStreamReader reader, ElementNode parent) throws XMLStreamException {
        ProcessingInstructionNode node;
        String pi = reader.getPITarget();
        Map<String, String> data = this.parseProcessingInstructionData(reader.getPIData());
        if (pi.equals(MAVEN_PLUGIN_LAYERS_PI)) {
            this.mavenPluginLayersPlaceholder = node = this.createProcessingInstruction(data, parent, pi, this.mavenPluginLayersPlaceholder);
        } else if (pi.equals(DOCKER_PLUGIN_ENV_VAR_PI)) {
            this.dockerPluginEnvVarsPlaceholder = node = this.createProcessingInstruction(data, parent, pi, this.dockerPluginEnvVarsPlaceholder);
        } else if (pi.equals(DATASOURCES_FEATURE_PACK_PI)) {
            this.datasourcesFeaturePackPlaceholder = node = this.createProcessingInstruction(data, parent, pi, this.dockerPluginEnvVarsPlaceholder);
        } else if (pi.equals(PROPERTY_OVERRIDES_PI)) {
            this.propertyOverridesPlaceholder = node = this.createProcessingInstruction(data, parent, pi, this.propertyOverridesPlaceholder);
        } else {
            throw new IllegalStateException("Unknown processing instruction " + this.toProcessingInstruction(reader.getPITarget()) + " " + reader.getLocation());
        }
        return node;
    }

    private ProcessingInstructionNode createProcessingInstruction(Map<String, String> data, ElementNode parent, String processingInstructionName, ProcessingInstructionNode existing) {
        if (!data.isEmpty()) {
            throw new IllegalStateException(this.toProcessingInstruction(processingInstructionName) + " should not take any data");
        }
        if (existing != null) {
            throw new IllegalStateException("Can only have one occurrence of " + this.toProcessingInstruction(processingInstructionName));
        }
        return new ProcessingInstructionNode(parent, processingInstructionName, null);
    }
}

