/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool.parser.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.managed.server.builder.tool.parser.Node;
import org.wildfly.managed.server.builder.tool.parser.generic.ElementNode;

public class ProcessingInstructionNode
implements Node {
    private final ElementNode parent;
    private final String name;
    private final Map<String, String> data;
    private List<Node> delegates = new ArrayList<Node>();

    public ProcessingInstructionNode(ElementNode parent, String name, Map<String, String> data) {
        this.parent = parent;
        this.name = name;
        this.data = data;
    }

    public void addDelegate(Node delegate, boolean useParentNs) {
        if (delegate != null) {
            if (useParentNs && delegate instanceof ElementNode) {
                delegate = ((ElementNode)delegate).updateForNewNsAndParent(this.parent, this.parent.getNamespace());
            }
            this.delegates.add(delegate);
        }
    }

    public ElementNode getParent() {
        return this.parent;
    }

    String getDataValue(String name, String defaultValue) {
        String s;
        if (this.data != null && (s = this.data.get(name)) != null) {
            return s;
        }
        return defaultValue;
    }

    @Override
    public void marshall(XMLStreamWriter writer) throws XMLStreamException {
        for (Node delegate : this.delegates) {
            delegate.marshall(writer);
        }
    }

    @Override
    public boolean hasContent() {
        for (Node delegate : this.delegates) {
            if (!delegate.hasContent()) continue;
            return true;
        }
        return false;
    }
}

