/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.managed.server.builder.tool.parser.serverconfig;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.managed.server.builder.tool.parser.serverconfig.Layers;
import org.wildfly.managed.server.builder.tool.parser.serverconfig.ServerConfig;

public class ServerConfigParser {
    private static final String ROOT_ELEMENT_NAME = "server-config";
    private final Path inputFile;
    private static final String SERVER_CONFIG = "server-config";

    public ServerConfigParser(Path inputFile) {
        this.inputFile = inputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig parse() throws IOException, XMLStreamException {
        ServerConfig serverConfig = null;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.inputFile.toFile()));
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            reader.require(7, null, null);
            block13: while (reader.hasNext()) {
                String element;
                if (reader.next() != 1) continue;
                switch (element = reader.getLocalName()) {
                    case "server-config": {
                        if (serverConfig != null) {
                            throw new XMLStreamException("Duplicate server-config elements", reader.getLocation());
                        }
                        serverConfig = this.parseServerConfig(reader);
                        continue block13;
                    }
                }
                throw new XMLStreamException("Unknown element: " + element, reader.getLocation());
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
        return serverConfig;
    }

    private ServerConfig parseServerConfig(XMLStreamReader reader) throws XMLStreamException {
        this.ensureNoAttributes(reader);
        Layers layers = null;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String element;
            switch (element = reader.getLocalName()) {
                case "layers": {
                    if (layers != null) {
                        throw new XMLStreamException("Duplicate layers elements");
                    }
                    layers = this.parseLayers(reader);
                    continue block6;
                }
            }
            throw new XMLStreamException("Unknown element: " + element, reader.getLocation());
        }
        return new ServerConfig(layers);
    }

    private Layers parseLayers(XMLStreamReader reader) throws XMLStreamException {
        this.ensureNoAttributes(reader);
        LinkedList<String> layers = new LinkedList<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String element;
            switch (element = reader.getLocalName()) {
                case "layer": {
                    this.ensureNoAttributes(reader);
                    layers.add(reader.getElementText());
                    continue block6;
                }
            }
            throw new XMLStreamException("Unknown element: " + element, reader.getLocation());
        }
        if (layers == null) {
            throw new XMLStreamException("No top level 'layers'", reader.getLocation());
        }
        return new Layers(layers);
    }

    private void ensureNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        this.readAttributes(reader, new String[0]);
    }

    private Map<String, String> readAttributes(XMLStreamReader reader, String ... attributes) throws XMLStreamException {
        HashMap<String, String> attributeValues = new HashMap<String, String>();
        HashSet<String> attributeNames = new HashSet<String>(Arrays.asList(attributes));
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            if (!attributeNames.contains(attr)) {
                throw new XMLStreamException("Unknown attribute: " + attr, reader.getLocation());
            }
            String value = reader.getAttributeValue(i);
            attributeValues.put(attr, value);
        }
        return attributeValues;
    }
}

