/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class SitemapEntry {
    private String loc;
    private Instant lastmod;

    private SitemapEntry(String loc, Instant lastmod) {
        this.loc = loc;
        this.lastmod = lastmod;
    }

    SitemapEntry(String loc, String lastmod) {
        this(loc, Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(lastmod)));
    }

    public SitemapEntry(String loc) {
        this(loc, Instant.EPOCH);
    }

    private String getLoc() {
        return this.loc;
    }

    public Instant getLastmod() {
        return this.lastmod;
    }

    public String toString() {
        return "SitemapEntry{loc='" + this.loc + '\'' + ", lastmod=" + this.lastmod + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SitemapEntry that = (SitemapEntry)o;
        return Objects.equals(this.getLoc(), that.getLoc());
    }

    public int hashCode() {
        return Objects.hash(this.getLoc());
    }
}

